#------------------------------------------------------------------------------
# Copyright (c) 2005, Enthought, Inc.
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
#
# Author: Enthought, Inc.
# Description: <Enthought pyface package component>
#------------------------------------------------------------------------------


from enthought.pyface.version import version, version as __version__


# Ensure the use of wxPython-2.6.x and above.
import wx
if wx.VERSION < (2,6) :
    raise RuntimeError, "Need wx version 2.6 or higher, but got %s" \
          % str(wx.VERSION)

# Create a wx application if one does not already exist.
_app = wx.GetApp()
if _app is None:
    _app = wx.PySimpleApp()
    _app.dummy_app = True

# Application window needs these (for the toolbar manager).
from image_cache import ImageCache
from widget import Widget

from about_dialog import AboutDialog
from application_window import ApplicationWindow
from background_progress_dialog import BackgroundProgressDialog
from confirmation_dialog import ConfirmationDialog, confirm
from constant import OK, CANCEL, YES, NO
from dialog import Dialog
from directory_dialog import DirectoryDialog
from expandable_panel import ExpandablePanel
from file_dialog import FileDialog
from filter import Filter
from gui import GUI
from heading_text import HeadingText
from image_resource import ImageResource
from image_widget import ImageWidget
from key_pressed_event import KeyPressedEvent
from layered_panel import LayeredPanel
from mdi_application_window import MDIApplicationWindow
from mdi_window_menu import MDIWindowMenu
from message_dialog import MessageDialog, error, information, warning
from multi_toolbar_window import MultiToolbarWindow
from progress_dialog import ProgressDialog
from python_editor import PythonEditor
from python_shell import PythonShell
from single_choice_dialog import SingleChoiceDialog
from sorter import Sorter
from splash_screen import SplashScreen
from split_application_window import SplitApplicationWindow
from split_dialog import SplitDialog
from split_panel import SplitPanel
from system_metrics import SystemMetrics
from window import Window

# Fix for broken Pycrust introspect module.
import util.fix_introspect_bug
