# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to edit breakpoint properties.
"""

from qt import *

from EditBreakpointForm import EditBreakpointForm


class EditBreakpointDialog(EditBreakpointForm):
    """
    Class implementing a dialog to edit breakpoint properties.
    """
    def __init__(self, properties, condHistory, parent = None,name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param properties properties for the breakpoint (tuple)
                (condition, temporary flag, enabled flag, ignore count)
        @param condHistory the list of conditionals history (QStringList)
        @param parent the parent of this dialog
        @param name the widget name of this dialog
        @param modal flag indicating a modal dialog
        @param fl the window flags
        """
        EditBreakpointForm.__init__(self,parent,name,modal,fl)
        
        dummy = self.trUtf8("Dummy")
        
        cond, temp, enabled, count = properties
        
        # set the condition
        if cond is None:
            cond = ''
        curr = condHistory.findIndex(cond)
        if curr == -1:
            condHistory.prepend(cond)
            curr = 0
        self.conditionCombo.insertStringList(condHistory)
        self.conditionCombo.setCurrentItem(curr)
        
        # set the ignore count
        self.ignoreSpinBox.setValue(count)
        
        # set the checkboxes
        self.temporaryCheckBox.setChecked(temp)
        self.enabledCheckBox.setChecked(enabled)
        
    def getData(self):
        """
        Public method to retrieve the entered data.
        
        @return a tuple containing the breakpoints new properties
            (condition, temporary flag, enabled flag, ignore count)
        """
        cond = self.conditionCombo.currentText()
        if cond.isEmpty():
            cond = None
            
        return (cond, self.temporaryCheckBox.isChecked(),
                self.enabledCheckBox.isChecked(), self.ignoreSpinBox.value())
