# -*- coding: utf-8 -*-

# Copyright (c) 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter options used to start a project in the VCS.
"""

import os

from qt import *

from KdeQt import KQFileDialog

from OptionsForm import HgOptionsForm

class HgOptionsDialog(HgOptionsForm):
    """
    Class implementing a dialog to enter options used to start a project in the repository.
    """
    def __init__(self, project, parent=None):
        """
        Constructor
        
        @param project reference to the project object
        @param parent parent widget (QWidget)
        """
        HgOptionsForm.__init__(self, parent, None, 1)
        
        self.project = project
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a dictionary containing the data entered
        """
        vcsdatadict = {
            "message" : unicode(self.vcsLogEdit.text()),
        }
        return vcsdatadict
