# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module defining the wizards interface to be implemented by individual wizards.
"""

from qt import QObject

class WizardIFace(QObject):
    """
    Base class defining the wizards interface to be implemented by individual wizards.
    
    Any child class has to implement these class methods:
        <dl>
        <dt>handle</dt><dd>the function to be executed</dd>
        <dt>getAction</dt><dd>returns the action associated</dd>
        </dl>
    """
    def __init__(self, parent = None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        QObject.__init__(self, parent)
    
    def handle(self):
        """
        Worker method associated with the wizard action 
        """
        raise RuntimeError, 'Not implemented'

    def initAction(self):
        '''
        Public method to create the action associated with this class wizard. 
        
        The following is an example.
        
        <pre>
        self.action = E3Action(self.trUtf8("Sample Wizard"),
             self.trUtf8("&Sample Wizard..."), 0, 0, self, 'wizards_sample')
        self.action.setStatusTip(self.trUtf8("Sample wizard"))
        self.action.setWhatsThis(self.trUtf8(
            """&lt;b&gt;Wizard&lt;/b&gt;"""
            """&lt;p&gt;Sample wizard&lt;/p&gt;"""
        ))
        self.action.connectIt(SIGNAL("activated()"), self.handle)
        return self.action
        </pre>
        
        @return the associated action
        '''
        raise RuntimeError, 'Not implemented'
    
    def getAction(self):
        """
        Public method to get the action associated with this class wizard. 
        
        The following is an example.
        
        <pre>
        return self.action
        </pre>
        
        @return the associated action
        """
        raise RuntimeError, 'Not implemented'
    
    def getTranslationFileBaseName(self):
        '''
        Public method to get the basename of the translation file.
        
        This basename must be given relative to the
        eric3 Wizards module in the form of a module path
        (e.g. ColorDialog.ColorDialog.ColorDialogTranslation_).
        This basename will be combined with the current locale to
        form the filename of the translation file to be loaded.
        
        @return basename of the translation file (string) or None
        '''
        return None     # default: no separate translation available
