# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the variable detail dialog.
"""

from qt import *

from VariableDetailForm import VariableDetailForm

class VariableDetailDialog(VariableDetailForm):
    """
    Class implementing the variable detail dialog.
    
    This dialog shows the name, the type and the value of a variable
    in a read only dialog. It is opened upon a double click in the
    variables viewer widget.
    """
    def __init__(self, var, vtype, value):
        """
        Constructor
        
        @param var the variables name (string or QString)
        @param vtype the variables type (string or QString)
        @param value the variables value (string or QString)
        """
        VariableDetailForm.__init__(self, None, None, 1)
        
        # to get around a quirk in PyQt if the subclass has no translatable strings
        dummy = self.trUtf8('Dummy')
        
        # set the different fields
        self.eName.setText(var)
        self.eType.setText(vtype)
        self.eValue.setText(value)
