# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to set the canvas sizes.
"""

from qt import *

from UMLCanvasSizeForm import UMLCanvasSizeForm


class UMLCanvasSizeDialog(UMLCanvasSizeForm):
    """
    Class implementing a dialog to set the canvas sizes.
    """
    def __init__(self, w, h, minW, minH,
        parent = None, name = None, modal = 0, fl = 0):
        """
        Constructor
        
        @param w current width of canvas (integer)
        @param h current height of canvas (integer)
        @param minW minimum width allowed (integer)
        @param minH minimum height allowed (integer)
        @param parent parent widget of this dialog (QWidget)
        @param name name of this widget (QString or string)
        @param modal flag indicating a modal dialog (boolean)
        @param fl window flags
        """
        UMLCanvasSizeForm.__init__(self,parent,name,modal,fl)
        
        dummy = self.trUtf8('dummy')
        
        self.widthSpinBox.setValue(w)
        self.heightSpinBox.setValue(h)
        self.widthSpinBox.setMinValue(minW)
        self.heightSpinBox.setMinValue(minH)
        self.widthSpinBox.selectAll()
        self.widthSpinBox.setFocus()
        
    def getData(self):
        """
        Method to retrieve the entered data.
        
        @return tuple giving the selected width and height
            (integer, integer)
        """
        return (self.widthSpinBox.value(), self.heightSpinBox.value())
