# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use the KDE Printer instead of the Qt Printer.
"""

try:
    import os
    if os.getenv("e3nokde"):
        raise ImportError
        
    from qt import QPrinter
    from kdeprint import KPrinter
    class KQPrinter(KPrinter):
        """
        Compatibility class to use the KDE Printer instead of the Qt Printer.
        """
        ScreenResolution = QPrinter.ScreenResolution
        PrinterResolution = QPrinter.PrinterResolution
        HighResolution = QPrinter.HighResolution
        Compatible = QPrinter.Compatible

except (ImportError, RuntimeError):
    from qt import QPrinter
    class KQPrinter(QPrinter):
        """
        Compatibility class to use the Qt Printer.
        """
        pass
