# -*- coding: utf-8 -*-

# Copyright (c) 2005 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the VCS project helper for CVS.
"""

from qt import *

from VCS.ProjectHelper import VcsProjectHelper
from UI.E3Action import E3Action

class CvsProjectHelper(VcsProjectHelper):
    """
    Class implementing the VCS project helper for CVS.
    """
    def __init__(self, vcsObject, projectObject, parent=None, name=None):
        """
        Constructor
        
        @param vcsObject reference to the vcs object
        @param projectObject reference to the project object
        @param parent parent widget (QWidget)
        @param name name of this object (string or QString)
        """
        VcsProjectHelper.__init__(self, vcsObject, projectObject, parent, name)
        
    def initActions(self):
        """
        Private method to generate the action objects.
        """
        self.vcsNewAct = E3Action(self.trUtf8('New from repository'),
                self.trUtf8('&New from repository...'),0,0,self,'cvs_new')
        self.vcsNewAct.setStatusTip(self.trUtf8(
            'Create a new project from the VCS repository'
        ))
        self.vcsNewAct.setWhatsThis(self.trUtf8(
            """<b>New from repository</b>"""
            """<p>This creates a new local project from the VCS repository.</p>"""
        ))
        self.vcsNewAct.connectIt(SIGNAL('activated()'),self.vcsCheckout)
        self.actions.append(self.vcsNewAct)
        
        self.vcsUpdateAct = E3Action(self.trUtf8('Update from repository'),
                self.trUtf8('&Update from repository'),0,0,self,
                'cvs_update')
        self.vcsUpdateAct.setStatusTip(self.trUtf8(
            'Update the local project from the VCS repository'
        ))
        self.vcsUpdateAct.setWhatsThis(self.trUtf8(
            """<b>Update from repository</b>"""
            """<p>This updates the local project from the VCS repository.</p>"""
        ))
        self.vcsUpdateAct.connectIt(SIGNAL('activated()'),self.vcsUpdate)
        self.actions.append(self.vcsUpdateAct)
        
        self.vcsCommitAct = E3Action(self.trUtf8('Commit changes to repository'),
                self.trUtf8('&Commit changes to repository...'),0,0,self,
                'cvs_commit')
        self.vcsCommitAct.setStatusTip(self.trUtf8(
            'Commit changes to the local project to the VCS repository'
        ))
        self.vcsCommitAct.setWhatsThis(self.trUtf8(
            """<b>Commit changes to repository</b>"""
            """<p>This commits changes to the local project to the VCS repository.</p>"""
        ))
        self.vcsCommitAct.connectIt(SIGNAL('activated()'),self.vcsCommit)
        self.actions.append(self.vcsCommitAct)
        
        self.vcsAddAct = E3Action(self.trUtf8('Add to repository'),
                self.trUtf8('&Add to repository...'),0,0,self,'cvs_add')
        self.vcsAddAct.setStatusTip(self.trUtf8(
            'Add the local project to the VCS repository'
        ))
        self.vcsAddAct.setWhatsThis(self.trUtf8(
            """<b>Add to repository</b>"""
            """<p>This adds (imports) the local project to the VCS repository.</p>"""
        ))
        self.vcsAddAct.connectIt(SIGNAL('activated()'),self.vcsImport)
        self.actions.append(self.vcsAddAct)
        
        self.vcsRemoveAct = E3Action(self.trUtf8(
                'Remove from repository (and disk)'),
                self.trUtf8('&Remove from repository (and disk)'),
                0,0,self,'cvs_remove')
        self.vcsRemoveAct.setStatusTip(self.trUtf8(
            'Remove the local project from the VCS repository (and  disk)'
        ))
        self.vcsRemoveAct.setWhatsThis(self.trUtf8(
            """<b>Remove from repository</b>"""
            """<p>This removes the local project from the VCS repository (and disk).</p>"""
        ))
        self.vcsRemoveAct.connectIt(SIGNAL('activated()'),self.vcsRemove)
        self.actions.append(self.vcsRemoveAct)
        
        self.vcsLogAct = E3Action(self.trUtf8(
                'Show log'),
                self.trUtf8('Show &log'),
                0, 0, self, 'cvs_log')
        self.vcsLogAct.setStatusTip(self.trUtf8(
            'Show the log of the local project'
        ))
        self.vcsLogAct.setWhatsThis(self.trUtf8(
            """<b>Show log</b>"""
            """<p>This shows the log of the local project.</p>"""
        ))
        self.vcsLogAct.connectIt(SIGNAL('activated()'),self.vcsLog)
        self.actions.append(self.vcsLogAct)
        
        self.vcsDiffAct = E3Action(self.trUtf8('Show difference'),
                self.trUtf8('Show &difference'),
                0, 0, self, 'cvs_diff')
        self.vcsDiffAct.setStatusTip(self.trUtf8(
            'Show the difference of the local project to the repository'
        ))
        self.vcsDiffAct.setWhatsThis(self.trUtf8(
            """<b>Show difference</b>"""
            """<p>This shows the difference of the local project to the repository.</p>"""
        ))
        self.vcsDiffAct.connectIt(SIGNAL('activated()'),self.vcsDiff)
        self.actions.append(self.vcsDiffAct)
        
        self.vcsStatusAct = E3Action(self.trUtf8('Show status'),
                self.trUtf8('Show &status'),
                0, 0, self, 'cvs_status')
        self.vcsStatusAct.setStatusTip(self.trUtf8(
            'Show the status of the local project'
        ))
        self.vcsStatusAct.setWhatsThis(self.trUtf8(
            """<b>Show status</b>"""
            """<p>This shows the status of the local project.</p>"""
        ))
        self.vcsStatusAct.connectIt(SIGNAL('activated()'),self.vcsStatus)
        self.actions.append(self.vcsStatusAct)
        
        self.vcsTagAct = E3Action(self.trUtf8('Tag in repository'), 
                self.trUtf8('&Tag in repository...'),
                0, 0, self, 'cvs_tag')
        self.vcsTagAct.setStatusTip(self.trUtf8(
            'Tag the local project in the repository'
        ))
        self.vcsTagAct.setWhatsThis(self.trUtf8(
            """<b>Tag in repository</b>"""
            """<p>This tags the local project in the repository.</p>"""
        ))
        self.vcsTagAct.connectIt(SIGNAL('activated()'),self.vcsTag)
        self.actions.append(self.vcsTagAct)
        
        self.vcsExportAct = E3Action(self.trUtf8('Export from repository'), 
                self.trUtf8('&Export from repository...'),
                0, 0, self, 'cvs_export')
        self.vcsExportAct.setStatusTip(self.trUtf8(
            'Export a project from the repository'
        ))
        self.vcsExportAct.setWhatsThis(self.trUtf8(
            """<b>Export from repository</b>"""
            """<p>This exports a project from the repository.</p>"""
        ))
        self.vcsExportAct.connectIt(SIGNAL('activated()'),self.vcsExport)
        self.actions.append(self.vcsExportAct)
        
        self.vcsPropsAct = E3Action(self.trUtf8('Command options'),
                self.trUtf8('Command &options...'),0,0,self,
                'cvs_options')
        self.vcsPropsAct.setStatusTip(self.trUtf8('Show the VCS command options'))
        self.vcsPropsAct.setWhatsThis(self.trUtf8(
            """<b>Command options...</b>"""
            """<p>This shows a dialog to edit the VCS command options.</p>"""
        ))
        self.vcsPropsAct.connectIt(SIGNAL('activated()'),self.vcsCommandOptions)
        self.actions.append(self.vcsPropsAct)
        
        self.vcsRevertAct = E3Action(self.trUtf8('Revert changes'),
                self.trUtf8('Re&vert changes'),
                0, 0, self, 'cvs_revert')
        self.vcsRevertAct.setStatusTip(self.trUtf8(
            'Revert all changes made to the local project'
        ))
        self.vcsRevertAct.setWhatsThis(self.trUtf8(
            """<b>Revert changes</b>"""
            """<p>This reverts all changes made to the local project.</p>"""
        ))
        self.vcsRevertAct.connectIt(SIGNAL('activated()'),self.vcsRevert)
        self.actions.append(self.vcsRevertAct)
        
        self.vcsMergeAct = E3Action(self.trUtf8('Merge'),
                self.trUtf8('Mer&ge changes...'),
                0, 0, self, 'cvs_merge')
        self.vcsMergeAct.setStatusTip(self.trUtf8(
            'Merge changes of a tag/revision into the local project'
        ))
        self.vcsMergeAct.setWhatsThis(self.trUtf8(
            """<b>Merge</b>"""
            """<p>This merges changes of a tag/revision into the local project.</p>"""
        ))
        self.vcsMergeAct.connectIt(SIGNAL('activated()'),self.vcsMerge)
        self.actions.append(self.vcsMergeAct)
        
        self.vcsSwitchAct = E3Action(self.trUtf8('Switch'),
                self.trUtf8('S&witch...'),
                0, 0, self, 'cvs_switch')
        self.vcsSwitchAct.setStatusTip(self.trUtf8(
            'Switch the local copy to another tag/branch'
        ))
        self.vcsSwitchAct.setWhatsThis(self.trUtf8(
            """<b>Switch</b>"""
            """<p>This switches the local copy to another tag/branch.</p>"""
        ))
        self.vcsSwitchAct.connectIt(SIGNAL('activated()'),self.vcsSwitch)
        self.actions.append(self.vcsSwitchAct)
        
        self.vcsCleanupAct = E3Action(self.trUtf8('Cleanup'),
                self.trUtf8('Cleanu&p'),
                0, 0, self, 'cvs_cleanup')
        self.vcsCleanupAct.setStatusTip(self.trUtf8(
            'Cleanup the local project'
        ))
        self.vcsCleanupAct.setWhatsThis(self.trUtf8(
            """<b>Cleanup</b>"""
            """<p>This performs a cleanup of the local project.</p>"""
        ))
        self.vcsCleanupAct.connectIt(SIGNAL('activated()'),self.vcsCleanup)
        self.actions.append(self.vcsCleanupAct)
        
        self.vcsCommandAct = E3Action(self.trUtf8('Execute command'),
                self.trUtf8('E&xecute command...'),
                0, 0, self, 'cvs_command')
        self.vcsCommandAct.setStatusTip(self.trUtf8(
            'Execute an arbitrary VCS command'
        ))
        self.vcsCommandAct.setWhatsThis(self.trUtf8(
            """<b>Execute command</b>"""
            """<p>This opens a dialog to enter an arbitrary VCS command.</p>"""
        ))
        self.vcsCommandAct.connectIt(SIGNAL('activated()'),self.vcsCommand)
        self.actions.append(self.vcsCommandAct)
        
        self.cvsLoginAct = E3Action(self.trUtf8('Login to repository'),
                self.trUtf8('Log&in to repository...'),0,0,self,'cvs_login')
        self.cvsLoginAct.setStatusTip(self.trUtf8(
            'Login to repository'
        ))
        self.cvsLoginAct.setWhatsThis(self.trUtf8(
            """<b>Login to repository</b>"""
            """<p>This performs a login to the VCS repository.</p>"""
        ))
        self.cvsLoginAct.connectIt(SIGNAL('activated()'),self.cvsLogin)
        self.actions.append(self.cvsLoginAct)
        
        self.cvsLogoutAct = E3Action(self.trUtf8('Logout from repository'),
                self.trUtf8('Log&out from repository...'), 0, 0, self, 'cvs_logout')
        self.cvsLogoutAct.setStatusTip(self.trUtf8(
            'Logout from repository'
        ))
        self.cvsLogoutAct.setWhatsThis(self.trUtf8(
            """<b>Logout from repository</b>"""
            """<p>This performs a logout from the VCS repository.</p>"""
        ))
        self.cvsLogoutAct.connectIt(SIGNAL('activated()'),self.cvsLogout)
        self.actions.append(self.cvsLogoutAct)
    
    def initMenu(self):
        """
        Private method to generate the VCS menu.
        """
        try:
            menu = self.project.vcsMenu
        except:
            return
        menu.clear()

        # build CVS admin submenu
        cvsMenu = QPopupMenu(menu)
        cvsMenu.insertTearOffHandle()
        self.cvsLoginAct.addTo(cvsMenu)
        self.cvsLogoutAct.addTo(cvsMenu)
        
        lbl = QLabel(self.vcs.vcsName(), menu)
        lbl.setFrameStyle( QFrame.Panel | QFrame.Sunken )
        lbl.setAlignment(Qt.AlignHCenter)
        font = lbl.font()
        font.setBold(1)
        lbl.setFont(font)
        menu.insertItem(lbl)
        
        menu.insertTearOffHandle()
        
        self.vcsUpdateAct.addTo(menu)
        self.vcsCommitAct.addTo(menu)
        menu.insertSeparator()
        self.vcsNewAct.addTo(menu)
        self.vcsExportAct.addTo(menu)
        menu.insertSeparator()
        self.vcsAddAct.addTo(menu)
        self.vcsRemoveAct.addTo(menu)
        menu.insertSeparator()
        self.vcsTagAct.addTo(menu)
        menu.insertSeparator()
        self.vcsLogAct.addTo(menu)
        self.vcsDiffAct.addTo(menu)
        menu.insertSeparator()
        self.vcsRevertAct.addTo(menu)
        self.vcsMergeAct.addTo(menu)
        menu.insertSeparator()
        self.vcsSwitchAct.addTo(menu)
        menu.insertSeparator()
        self.vcsCleanupAct.addTo(menu)
        menu.insertItem(self.trUtf8("CVS Administration"), cvsMenu)
        menu.insertSeparator()
        self.vcsCommandAct.addTo(menu)
        menu.insertSeparator()
        self.vcsPropsAct.addTo(menu)

    def cvsLogin(self):
        """
        Private slot used to login to a remote repository.
        """
        self.vcs.cvsLogin()

    def cvsLogout(self):
        """
        Private slot used to logout from a remote repository.
        """
        self.vcs.cvsLogout()
