# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the data for a copy operation.
"""

import os.path

from qt import *

from KdeQt import KQFileDialog

from CopyForm import CopyForm

class SvnCopyDialog(CopyForm):
    """
    Class implementing a dialog to enter the data for a copy operation.
    """
    def __init__(self, source, parent = None, move = 0):
        """
        Constructor
        
        @param source name of the source file/directory (QString)
        @param parent parent widget (QWidget)
        @param move flag indicating a move operation
        """
        CopyForm.__init__(self, parent, None, 1)
       
        if move:
            self.setCaption(self.trUtf8('Subversion Move'))
        
        self.sourceEdit.setText(source)
        self.source = source
        
    def getData(self):
        """
        Public method to retrieve the copy data.
        
        @return the target name (QString)
        """
        return self.targetEdit.text()
        
    def handleTarget(self):
        """
        Private slot to handle the button press for selecting the target via a selection dialog.
        """
        if os.path.isdir(self.source):
            target = KQFileDialog.getExistingDirectory(\
                self.targetEdit.text(),
                None, None,
                self.trUtf8("Select target"),
                1, 1)
        else:
            target = KQFileDialog.getSaveFileName(\
                self.targetEdit.text(),
                QString.null,
                None, None,
                self.trUtf8("Select target"),
                None, 1)
        
        if not target.isEmpty():
            self.targetEdit.setText(target)
