# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Subversion Options Dialog for a new project from the repository.
"""

import os

from qt import *

from KdeQt import KQFileDialog

from NewProjectForm import SvnNewProjectOptionsForm
from Config import ConfigSvnProtocols

class SvnNewProjectOptionsDialog(SvnNewProjectOptionsForm):
    """
    Class implementing the Options Dialog for a new project from the repository.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        SvnNewProjectOptionsForm.__init__(self, parent, None, 1)
        
        self.protocolCombo.insertStringList(ConfigSvnProtocols)
        
        hd = QDir.convertSeparators(QDir.homeDirPath())
        hd = os.path.join(unicode(hd), 'subversionroot')
        self.vcsDirectoryEdit.setText(hd)
        self.localPath = unicode(hd)
        self.networkPath = "localhost/"
        self.localProtocol = 1
        
    def handleDirectory(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsDirectoryEdit.text(),
            self, None, self.trUtf8("Select Repository-Directory"), 1)
            
        if not directory.isNull():
            self.vcsDirectoryEdit.setText(QDir.convertSeparators(directory))
        
    def handleProjectDir(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsProjectDirEdit.text(),
            self, None, self.trUtf8("Select Project Directory"), 1)
            
        if not directory.isNull():
            self.vcsProjectDirEdit.setText(QDir.convertSeparators(directory))
        
    def handleLayoutToggled(self, checked):
        """
        Private slot to handle the change of the layout checkbox.
        
        @param checked flag indicating the state of the checkbox (boolean)
        """
        self.vcsTagLabel.setEnabled(checked)
        self.vcsTagEdit.setEnabled(checked)
        if not checked:
            self.vcsTagEdit.clear()
        
    def handleProtocol(self, protocol):
        """
        Private slot to switch the status of the directory selection button.
        """
        if str(protocol) == "file://":
            self.vcsDirButton.setEnabled(1)
            self.networkPath = unicode(self.vcsDirectoryEdit.text())
            self.vcsDirectoryEdit.setText(self.localPath)
            self.localProtocol = True
        else:
            self.vcsDirButton.setEnabled(0)
            if self.localProtocol:
                self.localPath = unicode(self.vcsDirectoryEdit.text())
                self.vcsDirectoryEdit.setText(self.networkPath)
                self.localProtocol = False
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of a string (project directory) and a dictionary
            containing the data entered.
        """
        vcsdatadict = {
            "url" : '%s%s' % (str(self.protocolCombo.currentText()),
                              unicode(self.vcsDirectoryEdit.text())),
            "tag" : unicode(self.vcsTagEdit.text()),
            "standardLayout" : self.layoutCheckBox.isChecked(),
        }
        return (unicode(self.vcsProjectDirEdit.text()), vcsdatadict)
