# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the data for a new property.
"""

from qt import *

from KdeQt import KQFileDialog

from PropSetForm import PropSetForm

class SvnPropSetDialog(PropSetForm):
    """
    Module implementing a dialog to enter the data for a new property.
    """
    def __init__(self, parent = None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        PropSetForm.__init__(self, parent)
        
    def selectPropertyFile(self):
        """
        Private slot called by pressing the file selection button.
        """
        fn = KQFileDialog.getOpenFileName(\
            self.propFileEdit.text(),
            QString.null,
            self, None,
            self.trUtf8("Select file for property"),
            None, 1)
            
        if not fn.isEmpty():
            self.propFileEdit.setText(QDir.convertSeparators(fn))
    
    def getData(self):
        """
        Public slot used to retrieve the data entered into the dialog.
        
        @return tuple of three values giving the property name, a flag
            indicating a file was selected and the text of the property
            or the selected filename. (QString, boolean, QString)
        """
        if self.fileRadioButton.isChecked():
            return (self.propNameEdit.text(), 1, self.propFileEdit.text())
        else:
            return (self.propNameEdit.text(), 0, self.propTextEdit.text())
