# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the file dialog wizard dialog.
"""

import os

from qt import *

from FileDialogWizardForm import FileDialogWizardForm

class FileDialogWizardDialog(FileDialogWizardForm):
    """
    Module implementing the color dialog wizard dialog.
    
    It displays a dialog for entering the parameters
    for the QFileDialog code generator.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        FileDialogWizardForm.__init__(self, parent, None, 1)
        
        # to get around a quirk in PyQt if the subclass has no translatable strings
        dummy = self.trUtf8('Dummy')
        
        uitype = qApp.mainWidget().getProject().getUiType()
        if uitype == "Qt4":
            self.rQt4.setChecked(True)
        
    def testDlg(self):
        """
        Private method to test the selected options.
        """
        if self.rOpenFile.isChecked():
            QFileDialog.getOpenFileName(\
                self.eStartWith.text(),
                self.eFilters.text(),
                None, None,
                self.eCaption.text(),
                None,
                self.cSymlinks.isChecked())
        elif self.rOpenFiles.isChecked():
            QFileDialog.getOpenFileNames(\
                self.eFilters.text(),
                self.eStartWith.text(),
                None, None,
                self.eCaption.text(),
                None,
                self.cSymlinks.isChecked())
        elif self.rSaveFile.isChecked():
            QFileDialog.getSaveFileName(\
                self.eStartWith.text(),
                self.eFilters.text(),
                None, None,
                self.eCaption.text(),
                None,
                self.cSymlinks.isChecked())
        elif self.rDirectory.isChecked():
            QFileDialog.getExistingDirectory(\
                self.eWorkDir.text(),
                None, None,
                self.eCaption.text(),
                self.cDirOnly.isChecked(),
                self.cSymlinks.isChecked())
        
    def handleToggleConfirmCheckBox(self):
        """
        Private slot to enable/disable the confirmation check box.
        """
        self.cConfirmOverwrite.setEnabled(\
            self.rQt4.isChecked() and self.rSaveFile.isChecked())
        
    def handleToggleGroupsAndTest(self):
        """
        Private slot to enable/disable certain groups and the test button.
        """
        if self.rDirectory.isChecked():
            self.filePropertiesGroup.setEnabled(False)
            self.dirPropertiesGroup.setEnabled(True)
            self.bTest.setDisabled(self.cWorkDir.isChecked())
        else:
            self.filePropertiesGroup.setEnabled(True)
            self.dirPropertiesGroup.setEnabled(False)
            self.bTest.setDisabled(\
                self.cStartWith.isChecked() or self.cFilters.isChecked())
        
    def getCode3(self, indLevel, indString):
        """
        Public method to get the source code for Qt3.
        
        @param indLevel indentation level (int)
        @param indString string used for indentation (space or tab) (string)
        @return generated code (string)
        """
        # calculate our indentation level and the indentation string
        il = indLevel + 1
        istring = il * indString
        
        # now generate the code
        code = 'QFileDialog.'
        if self.rOpenFile.isChecked():
            code += 'getOpenFileName(\\%s%s' % (os.linesep, istring)
            if self.eStartWith.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                if self.cStartWith.isChecked():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (unicode(self.eStartWith.text()), os.linesep, istring)
            if self.eFilters.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                if self.cFilters.isChecked():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (unicode(self.eFilters.text()), os.linesep, istring)
            code += 'None, None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (unicode(self.eCaption.text()), os.linesep, istring)
            code += 'None, %d)%s' % (self.cSymlinks.isChecked(), os.linesep)
        elif self.rOpenFiles.isChecked():
            code += 'getOpenFileNames(\\%s%s' % (os.linesep, istring)
            if self.eFilters.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                if self.cFilters.isChecked():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (unicode(self.eFilters.text()), os.linesep, istring)
            if self.eStartWith.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                if self.cStartWith.isChecked():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (unicode(self.eStartWith.text()), os.linesep, istring)
            code += 'None, None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (unicode(self.eCaption.text()), os.linesep, istring)
            code += 'None, %d)%s' % (self.cSymlinks.isChecked(), os.linesep)
        elif self.rSaveFile.isChecked():
            code += 'getSaveFileName(\\%s%s' % (os.linesep, istring)
            if self.eStartWith.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                if self.cStartWith.isChecked():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (unicode(self.eStartWith.text()), os.linesep, istring)
            if self.eFilters.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                if self.cFilters.isChecked():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (unicode(self.eFilters.text()), os.linesep, istring)
            code += 'None, None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (unicode(self.eCaption.text()), os.linesep, istring)
            code += 'None, %d)%s' % (self.cSymlinks.isChecked(), os.linesep)
        elif self.rDirectory.isChecked():
            code += 'getExistingDirectory(\\%s%s' % (os.linesep, istring)
            if self.eWorkDir.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                if self.cWorkDir.isChecked():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (unicode(self.eWorkDir.text()), os.linesep, istring)
            code += 'None, None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'QString.null,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (unicode(self.eCaption.text()), os.linesep, istring)
            code += '%d, %d)%s' % \
                (self.cDirOnly.isChecked(), self.cSymlinks.isChecked(), os.linesep)
            
        return code
        
    def getCode4(self, indLevel, indString):
        """
        Public method to get the source code for Qt4.
        
        @param indLevel indentation level (int)
        @param indString string used for indentation (space or tab) (string)
        @return generated code (string)
        """
        # calculate our indentation level and the indentation string
        il = indLevel + 1
        istring = il * indString
        
        # now generate the code
        code = 'QFileDialog.'
        if self.rOpenFile.isChecked():
            code += 'getOpenFileName(\\%s%s' % (os.linesep, istring)
            code += 'None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'QString(),%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (unicode(self.eCaption.text()), os.linesep, istring)
            if self.eStartWith.text().isEmpty():
                code += 'QString(),%s%s' % (os.linesep, istring)
            else:
                if self.cStartWith.isChecked():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (unicode(self.eStartWith.text()), os.linesep, istring)
            if self.eFilters.text().isEmpty():
                code += 'QString()'
            else:
                if self.cFilters.isChecked(): 
                    fmt = '%s' 
                else: 
                    fmt = 'self.trUtf8("%s")' 
                code += fmt % unicode(self.eFilters.text()) 
            code += ',%s%sNone' % (os.linesep, istring)
            if not self.cSymlinks.isChecked():
                code += ',%s%sQFileDialog.Options(QFileDialog.DontResolveSymlinks)' % \
                        (os.linesep, istring)
            code += ')%s' % os.linesep
        elif self.rOpenFiles.isChecked():
            code += 'getOpenFileNames(\\%s%s' % (os.linesep, istring)
            code += 'None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'QString(),%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (unicode(self.eCaption.text()), os.linesep, istring)
            if self.eStartWith.text().isEmpty():
                code += 'QString(),%s%s' % (os.linesep, istring)
            else:
                if self.cStartWith.isChecked():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (unicode(self.eStartWith.text()), os.linesep, istring)
            if self.eFilters.text().isEmpty():
                code += 'QString()'
            else:
                if self.cFilters.isChecked(): 
                    fmt = '%s' 
                else: 
                    fmt = 'self.trUtf8("%s")' 
                code += fmt % unicode(self.eFilters.text()) 
            code += ',%s%sNone' % (os.linesep, istring)
            if not self.cSymlinks.isChecked():
                code += ',%s%sQFileDialog.Options(QFileDialog.DontResolveSymlinks)' % \
                        (os.linesep, istring)
            code += ')%s' % os.linesep
        elif self.rSaveFile.isChecked():
            code += 'getSaveFileName(\\%s%s' % (os.linesep, istring)
            code += 'None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'QString(),%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (unicode(self.eCaption.text()), os.linesep, istring)
            if self.eStartWith.text().isEmpty():
                code += 'QString(),%s%s' % (os.linesep, istring)
            else:
                if self.cStartWith.isChecked():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (unicode(self.eStartWith.text()), os.linesep, istring)
            if self.eFilters.text().isEmpty():
                code += 'QString()'
            else:
                if self.cFilters.isChecked(): 
                    fmt = '%s' 
                else: 
                    fmt = 'self.trUtf8("%s")' 
                code += fmt % unicode(self.eFilters.text()) 
            code += ',%s%sNone' % (os.linesep, istring)
            if (not self.cSymlinks.isChecked()) or (not self.cConfirmOverwrite.isChecked()):
                code += ',%s%sQFileDialog.Options(' % (os.linesep, istring)
                if not self.cSymlinks.isChecked():
                    code += 'QFileDialog.DontResolveSymlinks'
                if (not self.cSymlinks.isChecked()) and \
                   (not self.cConfirmOverwrite.isChecked()):
                    code += ' | '
                if not self.cConfirmOverwrite.isChecked():
                    code += 'QFileDialog.DontConfirmOverwrite'
                code += ')'
            code += ')%s' % os.linesep
        elif self.rDirectory.isChecked():
            code += 'getExistingDirectory(\\%s%s' % (os.linesep, istring)
            code += 'None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'QString(),%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (unicode(self.eCaption.text()), os.linesep, istring)
            if self.eWorkDir.text().isEmpty():
                code += 'QString()'
            else:
                if self.cWorkDir.isChecked():
                    fmt = '%s'
                else:
                    fmt = 'self.trUtf8("%s")'
                code += fmt % unicode(self.eWorkDir.text())
            code += ',%s%sQFileDialog.Options(' % (os.linesep, istring)
            if not self.cSymlinks.isChecked():
                code += 'QFileDialog.DontResolveSymlinks | '
            if self.cDirOnly.isChecked():
                code += 'QFileDialog.ShowDirsOnly'
            else:
                code += 'QFileDialog.Option(0)'
            code += '))%s' % os.linesep
            
        return code
        
    def getCode(self, indLevel, indString):
        """
        Public method to get the source code.
        
        @param indLevel -- indentation level (int)
        @param indString -- string used for indentation (space or tab) (string)
        @return generated code (string)
        """
        if self.rQt4.isChecked():
            return self.getCode4(indLevel, indString)
        else:
            return self.getCode3(indLevel, indString)
