# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Editor Properties (1) configuration page.
"""

from PyQt4.Qsci import QsciScintilla

from ConfigurationPageBase import ConfigurationPageBase
from Ui_EditorProperties1Page import Ui_EditorProperties1Page

import Preferences

class EditorProperties1Page(ConfigurationPageBase, Ui_EditorProperties1Page):
    """
    Class implementing the Editor Properties (1) configuration page.
    """
    def __init__(self):
        """
        Constructor
        
        @param lexers reference to the lexers dictionary
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("EditorProperties1Page")
        
        # set initial values
        self.allFoldCompactCheckBox.setChecked(\
            Preferences.getEditor("AllFoldCompact"))
        
        self.foldCppCommentCheckBox.setChecked(\
            Preferences.getEditor("CppFoldComment"))
        self.foldCppPreprocessorCheckBox.setChecked(\
            Preferences.getEditor("CppFoldPreprocessor"))
        self.foldCppAtElseCheckBox.setChecked(\
            Preferences.getEditor("CppFoldAtElse"))
        self.cppIndentOpeningBraceCheckBox.setChecked(\
            Preferences.getEditor("CppIndentOpeningBrace"))
        self.cppIndentClosingBraceCheckBox.setChecked(\
            Preferences.getEditor("CppIndentClosingBrace"))
        self.cppCaseInsensitiveCheckBox.setChecked(\
            Preferences.getEditor("CppCaseInsensitiveKeywords"))
        
        self.foldHtmlPreprocessorCheckBox.setChecked(\
            Preferences.getEditor("HtmlFoldPreprocessor"))
        self.htmlCaseSensitiveTagsCheckBox.setChecked(\
            Preferences.getEditor("HtmlCaseSensitiveTags"))
        
        self.foldBashCommentCheckBox.setChecked(\
            Preferences.getEditor("BashFoldComment"))
        
        self.foldCssCommentCheckBox.setChecked(\
            Preferences.getEditor("CssFoldComment"))
        
        self.foldDCommentCheckBox.setChecked(\
            Preferences.getEditor("DFoldComment"))
        self.foldDAtElseCheckBox.setChecked(\
            Preferences.getEditor("DFoldAtElse"))
        self.dIndentOpeningBraceCheckBox.setChecked(\
            Preferences.getEditor("DIndentOpeningBrace"))
        self.dIndentClosingBraceCheckBox.setChecked(\
            Preferences.getEditor("DIndentClosingBrace"))
        
        self.cmakeFoldAtElseCheckBox.setChecked(\
            Preferences.getEditor("CMakeFoldAtElse"))
        
    def save(self):
        """
        Public slot to save the Editor Properties (1) configuration.
        """
        Preferences.setEditor("AllFoldCompact",
            int(self.allFoldCompactCheckBox.isChecked()))
        
        Preferences.setEditor("CppFoldComment",
            int(self.foldCppCommentCheckBox.isChecked()))
        Preferences.setEditor("CppFoldPreprocessor",
            int(self.foldCppPreprocessorCheckBox.isChecked()))
        Preferences.setEditor("CppFoldAtElse",
            int(self.foldCppAtElseCheckBox.isChecked()))
        Preferences.setEditor("CppIndentOpeningBrace",
            int(self.cppIndentOpeningBraceCheckBox.isChecked()))
        Preferences.setEditor("CppIndentClosingBrace",
            int(self.cppIndentClosingBraceCheckBox.isChecked()))
        Preferences.setEditor("CppCaseInsensitiveKeywords",
            int(self.cppCaseInsensitiveCheckBox.isChecked()))
        
        Preferences.setEditor("HtmlFoldPreprocessor",
            int(self.foldHtmlPreprocessorCheckBox.isChecked()))
        Preferences.setEditor("HtmlCaseSensitiveTags",
            int(self.htmlCaseSensitiveTagsCheckBox.isChecked()))
        
        Preferences.setEditor("BashFoldComment",
            int(self.foldBashCommentCheckBox.isChecked()))
        
        Preferences.setEditor("CssFoldComment",
            int(self.foldCssCommentCheckBox.isChecked()))
        
        Preferences.setEditor("DFoldComment",
            int(self.foldDCommentCheckBox.isChecked()))
        Preferences.setEditor("DFoldAtElse",
            int(self.foldDAtElseCheckBox.isChecked()))
        Preferences.setEditor("DIndentOpeningBrace",
            int(self.dIndentOpeningBraceCheckBox.isChecked()))
        Preferences.setEditor("DIndentClosingBrace",
            int(self.dIndentClosingBraceCheckBox.isChecked()))
        
        Preferences.setEditor("CMakeFoldAtElse",
            int(self.cmakeFoldAtElseCheckBox.isChecked()))

def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = EditorProperties1Page()
    return page
