# -*- coding: utf-8 -*-

# Copyright (c) 2008 - 2009 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Terminal configuration page.
"""

from ConfigurationPageBase import ConfigurationPageBase
from Ui_TerminalPage import Ui_TerminalPage

import Preferences

class TerminalPage(ConfigurationPageBase, Ui_TerminalPage):
    """
    Class implementing the Terminal configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("TerminalPage")
        
        # set initial values
        self.linenowidthSlider.setValue(\
            Preferences.getTerminal("LinenoWidth"))
        self.linenoCheckBox.setChecked(\
            Preferences.getTerminal("LinenoMargin"))
        self.syntaxHighlightingCheckBox.setChecked(\
            Preferences.getTerminal("SyntaxHighlightingEnabled"))
        self.historySpinBox.setValue(\
            Preferences.getTerminal("MaxHistoryEntries"))
        self.rcFileCheckBox.setChecked(\
            Preferences.getTerminal("ReadRcFile"))
        
    def save(self):
        """
        Public slot to save the Shell configuration.
        """
        Preferences.setTerminal("LinenoWidth",
            self.linenowidthSlider.value())
        Preferences.setTerminal("LinenoMargin",
            int(self.linenoCheckBox.isChecked()))
        Preferences.setTerminal("SyntaxHighlightingEnabled",
            int(self.syntaxHighlightingCheckBox.isChecked()))
        Preferences.setTerminal("MaxHistoryEntries",
            self.historySpinBox.value())
        Preferences.setTerminal("ReadRcFile", 
            int(self.rcFileCheckBox.isChecked()))
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = TerminalPage()
    return page
