# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the general part of the interface to version control systems.

The general part of the VCS interface defines classes to implement common
dialogs. These are a dialog to enter command options, dialog for login and logout,
a dialog for entering the options to retrieve a new project from a VCS repository,
a dialog for entering the VCS options needed to start a new project in a 
VCS system and an abstract base class. The individual interfaces (i.e. CVS)
have to be subclasses of this base class.
"""

######################################################################
## Below is the factory function to instantiate the appropriate
## vcs object depending on the project settings.
######################################################################

def factory(vcs):
    """
    Modul factory function to generate the right vcs object.
    
    @param vcs name of the VCS system to be used
    @return the instantiated VCS object
    """
    exec 'from %sPackage.%s import %s' % (vcs.lower(), vcs.lower(), vcs.capitalize())
    exec 'vc = %s()' % vcs.capitalize()
    return vc
