# -*- coding: utf-8 -*-

# Copyright (c) 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the data for a tagging operation.
"""

from qt import *

from TagForm import TagForm

class SvnTagDialog(TagForm):
    """
    Class implementing a dialog to enter the data for a tagging operation.
    """
    def __init__(self, taglist, parent = None):
        """
        Constructor
        
        @param taglist list of previously entered tags (QStringList)
        @param parent parent widget (QWidget)
        """
        TagForm.__init__(self, parent, None, 1)
       
        dummy = self.trUtf8('dummy')
        
        self.tagCombo.clear()
        self.tagCombo.insertStringList(taglist)
        
    def enableOkButton(self, text):
        """
        Private method used to enable/disable the OK-button.
        
        @param text ignored
        """
        self.okButton.setDisabled(text.isEmpty())
    
    def getParameters(self):
        """
        Public method to retrieve the tag data.
        
        @return tuple of QString and int (tag, tag operation)
        """
        tag = self.tagCombo.currentText()
        tagOp = 0
        if self.createRegularButton.isChecked():
            tagOp = 1
        elif self.createBranchButton.isChecked():
            tagOp = 2
        elif self.deleteRegularButton.isChecked():
            tagOp = 4
        elif self.deleteBranchButton.isChecked():
            tagOp = 8
        return (tag, tagOp)

