# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Package implementing the viewmanager of the eric3 IDE.

The viewmanager is responsible for the layout of the editor windows. This is
the central part of the IDE. In additon to this, the viewmanager provides all
editor related actions, menus and toolbars.

There are three different types of viewmanagers available. The first one
displays the editors on a workspace, the second using tabs and the third
names the open editors in a listview with the editing area right of it.
"""

import Preferences

######################################################################
## Below is the factory function to instantiate the appropriate
## viewmanager depending on the configuration settings
######################################################################

def factory(parent, ui, dbs):
    """
    Modul factory function to generate the right viewmanager type.
    
    The viewmanager is instantiated depending on the data set in
    the current preferences.
    
    @param parent parent widget (QWidget)
    @param ui reference to the main UI object
    @param dbs reference to the debug server object
    @return the instantiated viewmanager
    """
    viewManagerStr = Preferences.getViewManager().capitalize()
    exec 'from %s import %s' % (viewManagerStr, viewManagerStr)
    exec 'vm = %s(parent, ui, dbs)' % viewManagerStr
    return vm
