%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved via the world wide web at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Initial Developer of the Original Code is Ericsson Utvecklings AB.
%% Portions created by Ericsson are Copyright 1999, Ericsson Utvecklings
%% AB. All Rights Reserved.''
%% 
%%     $Id$
%%
-module(call_bm).
-include("bench.hrl").
-export([benchmarks/0]).
-export([local_call/1,external_call/1,fun_call/1,apply_fun/1,apply_mfa/1]).
-export([foo/0]).

benchmarks() ->
    {400000,[local_call,external_call,fun_call,apply_fun,apply_mfa]}.

local_call(0) ->
    ok;
local_call(Iter) ->
    ?rep40(foo()),
    local_call(Iter-1).

external_call(0) ->
    ok;
external_call(Iter) ->
    ?rep40(?MODULE:foo()),
    external_call(Iter-1).

fun_call(Iter) ->
    fun_call(Iter, fun() -> ok end).
fun_call(0, Fun) ->
    ok;
fun_call(Iter, Fun) ->
    ?rep40(Fun()),
    fun_call(Iter-1, Fun).

apply_fun(Iter) ->
    apply_fun(Iter, fun() -> ok end).
apply_fun(0, Fun) ->
    ok;
apply_fun(Iter, Fun) ->
    ?rep40(apply(Fun, [])),
    apply_fun(Iter-1, Fun).

apply_mfa(0) ->
    ok;
apply_mfa(Iter) ->
    ?rep40(apply(?MODULE, foo, [])),
    apply_mfa(Iter-1).

foo() -> ok.
