/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.1, (the "License"); you may not use this file except in
 * compliance with the License. You should have received a copy of the
 * Erlang Public License along with this software. If not, it can be
 * retrieved via the world wide web at http://www.erlang.org/.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Original Code is Ericsson Utvecklings AB.
 * Portions created by Ericsson are Copyright 1999, Ericsson Utvecklings
 * AB. All Rights Reserved.''
 * 
 *     $Id$
 */
/**
 * A Holder class for IDL's out/inout argument passing modes for byte
 *
 */
package com.ericsson.otp.ic;

/**

Holder class for Byte, according to OMG-IDL java mapping.

**/ 

final public class ByteHolder implements Holder  {
    public byte value;
    
    public ByteHolder() {}
    
    public ByteHolder(byte initial) {
	value = initial;
    }

    /* Extra methods not in standard. */
     /**
      Comparisson method for Bytes.
      @return true if the input object equals the current object, false otherwize
      **/
    public boolean equals( Object obj ) {
	if( obj instanceof Byte )
	    return ( value == ((Byte)obj).byteValue());
	else
	    return false;
    }

    /**
      Comparisson method for Byte.
      @return true if the input boolean value equals the value of the current object, false otherwize
      **/
    public boolean equals( byte b ) {
	return ( value == b);
    }
    
}
