"""

ERoaster preferences handling

"""

from os import environ
from constants import localedir, unixname
from tools import gettext
from sys import platform

gettext = gettext(unixname, localedir)
gettext.textdomain(unixname)
_ = gettext.gettext

import log4py

if ((platform != "win32") and (not environ.has_key("DISPLAY"))):              
    # This happens when started in a console on non win32 platforms
    raise ImportError, _("DISPLAY environment variable not set")

try:
    import pygtk
    pygtk.require('2.0')
except:
    pass

import gtk
import gtk.glade

from constants import gladedir

class Preferences:

    def __init__(self, loglevel = log4py.LOGLEVEL_NORMAL):
        self.__Preferences_logger = log4py.Logger().get_instance()
        self.__Preferences_logger.set_loglevel(loglevel)

    def show_window(self):
        xml = gtk.glade.XML("%s/eroaster-prefs.glade" % gladedir)
        closeButton = xml.get_widget("CloseButton")
        closeButton.connect("clicked", self.__Preferences_close_window)
        self.__Preferences_window = xml.get_widget("PrefWindow")
        self.__Preferences_window.show()

    def __Preferences_close_window(self, args):
        self.__Preferences_window.destroy()
