"""

Interface to lame (mp3 encoder)

"""

from tools import which
from log4py import Logger, LOGLEVEL_NORMAL
from string import find

MODE_STEREO = "s"
MODE_JOINT_STEREO = "j"
MODE_FORCED_JOINT_STEREO = "f"
MODE_DUAL_CHANNELS = "d"
MODE_MONO = "m"

class lame:

    source = None
    target = None
    bitrate = 128
    mode = MODE_JOINT_STEREO

    def __init__(self, loglevel = LOGLEVEL_NORMAL):
        self.__lame_logger = Logger().get_instance(self)
        self.__lame_logger.set_loglevel(loglevel)
        self.__lame_command = which("lame")
        if (self.__lame_command == ""):
            self.__lame_logger.debug("Lame executable not found.")

    def available(self):
        return (self.__lame_command != "")

    def command_line(self):
        if (self.source == None) or (self.target == None):
            return None
        else:
            command_line = self.__lame_command
            if (self.bitrate != 128):
                command_line = "%s -b %d" % (command_line, self.bitrate)
            if (self.mode != "j"):
                command_line = "%s -m %s" % (command_line, self.mode)
            if (find(self.source, " ") != -1):
                self.source = "\"%s\"" % self.source
            command_line = "%s %s" % (command_line, self.source)
            if (find(self.target, " ") != -1):
                self.target = "\"%s\"" % self.target
            command_line = "%s %s" % (command_line, self.target)
            return command_line

def test():
    lame_test = lame()
    print lame_test.available()
    lame_test.source = "-"
    lame_test.target = "/tmp/output.mp3"
    lame_test.bitrate = 192
    print lame_test.command_line()

if (__name__ == "__main__"):
    test()
