<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" encoding="UTF-8"/>

<xsl:template match="/">
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="estxview">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
<meta http-equiv="Content-Style-Type" content="text/css"/>
<title>Estraier: a personal full-text search system</title>
<style type="text/css">
body { margin: 1em; 1em; background: #ffffff none; color: #443311; }
div.res { margin-top: 1.2em; margin-bottom: 1.2em; padding: 0.5em 0.5em;
  background-color: #ffffdd; border: outset 2pt #eeeedd; }
em.query { color: #332200; font-style: normal; font-weight: bold; }
dl { margin-top: 1.2em; margin-bottom: 1.2em; padding: 0.5em 0.5em;
  background-color: #eeeedd; border: outset 2pt #cccccc; }
dt { margin: 0.2em 0.8em 0.2em 0.2em; font-size: normal; color: #333333; }
dd { margin: 0.1em 0.8em 0.1em 1.6em; font-size: normal; color: #333333; }
dl.clust { margin: 0.5em 1.0em; padding: 0.1em 0.5em; color: #444444; font-size: smaller;
  background-color: #ffffee; border: dotted 1pt #cccccc; }
em.clcode, em.clhit { font-style: normal; }
span.clkey { margin: 0em 0.1em; padding: 0em 0.2em; color: #555555; }
dd.summary { padding: 0.1em 0.2em; color: #333311; font-size: smaller;
  height: 8em; overflow: auto; background-color: #ffffee; border: inset 1pt #888888; }
dd.text { padding: 0.1em 0.2em; color: #555533; font-size: smaller;
  height: 4em; overflow: auto; background-color: #ffffee; border: inset 1pt #888888; }
dd.keywords { color: #777755; font-size: smaller;
  height: 1.2em; overflow: hidden; background-color: #ffffee; border: inset 1pt #888888; }
dd.attributes { color: #444422; font-size: smaller; }
span.term { margin-left: 0.3em; margin-right: 0.3em; }
span.word { margin-left: 0.1em; margin-right: 0.1em; }
a.title { font-weight: bold; color: #0022aa; text-decoration: none; }
a.title:visited { color: #550088; }
a.title:hover { color: #1144ff; text-decoration: underline; }
em.author { color: #000000; font-style: normal; font-weight: bold; }
em.recipient { color: #000000; font-style: normal; font-weight: normal; }
em.multicast { color: #000000; font-style: normal; font-weight: normal; }
em.date { color: #000000; font-style: normal; font-weight: normal; }
em.type { color: #000000; font-style: normal; font-weight: normal; }
em.encoding { color: #000000; font-style: normal; font-weight: normal; }
em.size { color: #000000; font-style: normal; font-weight: normal; }
em.id { color: #000000; font-style: normal; font-weight: normal; }
em.uri { color: #118811; font-style: normal; font-weight: normal; }
em.realuri { color: #118811; font-style: normal; font-weight: normal; }
em.key { color: #001177; font-style: normal; font-weight: bold; }
div.wlist { margin-top: 1.2em; margin-bottom: 1.2em; padding: 0.5em 0.5em;
  background-color: #eeffdd; border: outset 2pt #eeeedd; }
span.hit { color: #777755; }
</style>
</head>
<body>
<xsl:apply-templates select="meta"/>
<xsl:apply-templates select="cluster"/>
<xsl:apply-templates select="document"/>
<xsl:apply-templates select="terms"/>
</body>
</html>
</xsl:template>

<xsl:template match="meta">
<div class="res">
<xsl:apply-templates select="query"/>
<xsl:apply-templates select="option"/>
<xsl:apply-templates select="error"/>
<xsl:apply-templates select="total"/>
<xsl:apply-templates select="remark"/>
</div>
</xsl:template>

<xsl:template match="query">
<div>
<span class="term">Query:</span>
<span class="term"><xsl:value-of select="@operator"/></span>
<span class="term"><em class="query"><xsl:value-of select="."/></em></span>
<xsl:if test="string-length(@hit) &gt; 0">
<span class="term">(<xsl:value-of select="@hit"/>)</span>
</xsl:if>
</div>
</xsl:template>

<xsl:template match="option">
<div>
<span class="term">Option:</span>
<span class="term">max=<xsl:value-of select="@max"/></span>
<span class="term">tfidf=<xsl:value-of select="@tfidf"/></span>
<span class="term">clshow=<xsl:value-of select="@clshow"/></span>
<span class="term">clcode=<xsl:value-of select="@clcode"/></span>
<span class="term">drep=<xsl:value-of select="@drep"/></span>
<span class="term">expr=<xsl:value-of select="@expr"/></span>
<span class="term">sort=<xsl:value-of select="@sort"/></span>
</div>
</xsl:template>

<xsl:template match="error">
<div>
<span class="term">Error:</span>
<span class="term">[<xsl:value-of select="@code"/>]</span>
<span class="term"><xsl:value-of select="@string"/></span>
</div>
</xsl:template>

<xsl:template match="total">
<div>
<span class="term">Total:</span>
<span class="term">hit=<xsl:value-of select="@hit"/></span>
<span class="term">dnum=<xsl:value-of select="@dnum"/></span>
<span class="term">wnum=<xsl:value-of select="@wnum"/></span>
</div>
</xsl:template>

<xsl:template match="remark">
<div>
<span class="term">Remark:</span>
<span class="remark"><xsl:value-of select="."/></span>
</div>
</xsl:template>

<xsl:template match="cluster">
<dl class="clust">
<dt>
<span class="term">Code: <em class="clcode"><xsl:value-of select="@code"/></em></span>
<span class="term">Hit: <em class="clhit"><xsl:value-of select="@hit"/></em></span>
</dt>
<dd>
<xsl:apply-templates select="clkey"/>
</dd>
</dl>
</xsl:template>

<xsl:template match="clkey">
<xsl:if test="string-length(.) &gt; 0">
<span class="clkey"><xsl:value-of select="."/> (<xsl:value-of select="@score"/>)</span>
<xsl:if test="position() != last()">
<xsl:text>
</xsl:text>
</xsl:if>
</xsl:if>
</xsl:template>

<xsl:template match="document">
<dl class="doc">
<xsl:if test="string-length(title) or string-length(@score) or string-length(@similarity)">
<dt>
<span class="term"><xsl:element name="a"><xsl:attribute name="href"><xsl:value-of select="uri"/></xsl:attribute><xsl:attribute name="class">title</xsl:attribute><xsl:value-of select="title"/></xsl:element></span>
<xsl:if test="string-length(@score) &gt; 0">
<span class="term">(<span class="score"><xsl:value-of select="@score"/></span> pt.)</span>
</xsl:if>
<xsl:if test="string-length(@similarity) &gt; 0">
<span class="term">(<span class="score"><xsl:value-of select="@similarity"/></span>%)</span>
</xsl:if>
</dt>
</xsl:if>
<dd class="attributes">
<xsl:apply-templates select="@id"/>
<xsl:apply-templates select="uri"/>
</dd>
<xsl:apply-templates select="realuri"/>
<dd class="attributes">
<xsl:apply-templates select="author"/>
<xsl:apply-templates select="recipient"/>
<xsl:apply-templates select="multicast"/>
<xsl:apply-templates select="date"/>
<xsl:apply-templates select="type"/>
<xsl:apply-templates select="encoding"/>
<xsl:apply-templates select="size"/>
</dd>
<xsl:apply-templates select="summary"/>
<xsl:apply-templates select="text"/>
<xsl:apply-templates select="keywords"/>
</dl>
</xsl:template>

<xsl:template match="@id">
<span class="term">ID: <em class="id"><xsl:value-of select="."/></em></span>
</xsl:template>

<xsl:template match="uri">
<span class="term">URI: <em class="uri"><xsl:value-of select="."/></em></span>
</xsl:template>

<xsl:template match="realuri">
<dd class="attributes">
<span class="term">Real URI: <em class="realuri"><xsl:value-of select="."/></em></span>
</dd>
</xsl:template>

<xsl:template match="author">
<span class="term">Author: <em class="author"><xsl:value-of select="."/></em></span>
</xsl:template>

<xsl:template match="recipient">
<span class="term">Recipient: <em class="recipient"><xsl:value-of select="."/></em></span>
</xsl:template>

<xsl:template match="multicast">
<span class="term">Multicast: <em class="multicast"><xsl:value-of select="."/></em></span>
</xsl:template>

<xsl:template match="date">
<span class="term">Date: <em class="date"><xsl:value-of select="."/></em></span>
</xsl:template>

<xsl:template match="type">
<span class="term">Type: <em class="type"><xsl:value-of select="."/></em></span>
</xsl:template>

<xsl:template match="encoding">
<span class="term">Encoding: <em class="encoding"><xsl:value-of select="."/></em></span>
</xsl:template>

<xsl:template match="size">
<span class="term">Size: <em class="size"><xsl:value-of select="."/></em></span>
</xsl:template>

<xsl:template match="summary">
<dd class="summary">
<xsl:apply-templates/>
</dd>
</xsl:template>

<xsl:template match="key">
<em class="key"><xsl:value-of select="."/></em>
</xsl:template>

<xsl:template match="text">
<dd class="text">
<xsl:apply-templates select="word"/>
</dd>
</xsl:template>

<xsl:template match="word">
<xsl:if test="string-length(.) &gt; 0">
<span class="word"><xsl:value-of select="."/></span>
<xsl:if test="position() != last()">
<xsl:text>
</xsl:text>
</xsl:if>
</xsl:if>
</xsl:template>

<xsl:template match="keywords">
<dd class="keywords">
<xsl:value-of select="."/>
</dd>
</xsl:template>

<xsl:template match="terms">
<div class="wlist">
<xsl:apply-templates select="term"/>
</div>
</xsl:template>

<xsl:template match="term">
<span class="term">
<span class="word"><xsl:value-of select="."/></span>
<span class="hit"><xsl:text> </xsl:text>(<xsl:value-of select="@hit"/>)</span>
</span>
<xsl:text>
</xsl:text>
</xsl:template>

</xsl:stylesheet>
