/*************************************************************************************************
 * JavaScript functions for merger.html
 *************************************************************************************************/



// alias of document.writeln
function println(str){
  document.writeln(str);
}


// escape meta characters of HTML
function hesc(str){
  var res = '';
  for(var i = 0; i < str.length; i++){
    var c = str.charAt(i);
    if(c == '&'){
      res += '&amp;';
    } else if(c == '<'){
      res += '&lt;';
    } else if(c == '>'){
      res += '&gt;';
    } else if(c == '"'){
      res += '&quot;';
    } else {
      res += c;
    }
  }
  return res;
}


// get the query string
function getquery(){
  var qstr = document.location.href;
  var qidx = qstr.indexOf('?');
  if(qidx < 0) return '';
  return qstr.substring(qidx + 1, qstr.length);
}


// get the value of a parameter
function getparam(name){
  var qstr = getquery();
  var qidx = qstr.indexOf(name + '=');
  if(qidx == -1) return '';
  qstr = qstr.substring(qidx + name.length + 1, qstr.length);
  qidx = qstr.indexOf('&');
  if(qidx != -1) qstr = qstr.substring(0, qidx);
  return qstr;
}


// get the path from a URL, from the root
function geturlpath(url){
  var tidx = url.indexOf('#');
  if(tidx != -1) url = url.substring(0, tidx);
  var qidx = url.indexOf('?');
  if(qidx != -1) url = url.substring(0, qidx);
  var pidx = url.indexOf('://');
  var sidx = url.indexOf('/');
  if(pidx != -1 && pidx < sidx){
    url = url.substring(pidx + 3, url.length);
    sidx = url.indexOf('/');
    if(sidx != -1) url = url.substring(sidx, url.length);
  }
  return url;
}


// Map: add element to the map
function map_put(key, val){
  for(var i = 0; i < this.keys.length; i++){
    if(this.keys[i] == key){
      this.vals[i] = val;
      return;
    }
  }
  this.keys.push(key);
  this.vals.push(val);
}


// Map: get the value of a key
function map_get(key){
  for(var i = 0; i < this.keys.length; i++){
    if(this.keys[i] == key){
      return this.vals[i];
    }
  }
  return null;
}


// class of map
function Map(){
  this.keys = new Array(0);
  this.vals = new Array(0);
  this.put = map_put;
  this.get = map_get;
}


// class of result document
function ResultDoc(onum, label, uri, title, score, author, date, type, enc, size, sumnode){
  this.onum = onum;
  this.label = label;
  this.uri = uri;
  this.title = title;
  this.score = score;
  this.author = author;
  this.date = date;
  this.type = type;
  this.enc = enc;
  this.size = size;
  this.sumnode = sumnode;
}


// compare two documents by scores
function comparedocs(a, b){
  var scsub = b.score - a.score;
  if(scsub != 0) return scsub;
  return a.onum - b.onum;
}


// show merged result
function showresult(){
  // get parameters
  var phrase = getparam('phrase');
  var max = getparam('max');
  if(max.length < 1) max = '8';
  max = parseInt(max);
  var skip = getparam('skip');
  if(skip.length < 1) skip = '0';
  skip = parseInt(skip);
  // get targets
  var targets = new Array(0);
  var frames = parent.frames;
  for(var i = 1; i < frames.length; i++){
    targets.push(frames[i]);
  }
  var labels = new Array(0);
  var tancs = parent.parent.iform.document.getElementsByTagName('a');
  for(var i = 0; i < targets.length; i++){
    var path = geturlpath(targets[i].document.location.href);
    var label = '';
    for(var j = 0; j < tancs.length; j++){
      if(geturlpath(tancs[j].getAttributeNode('href').value) != path) continue;
      label = tancs[j].firstChild.nodeValue;
    }
    if(label.length > 0){
      labels.push(label);
    } else {
      labels.push('Target' + (i + 1));
    }
  }
  // show search words
  var all = 0;
  for(var i = 0; i < targets.length; i++){
    var num = targets[i].document.getElementById('all');
    if(num == null) continue;
    num = num.firstChild.nodeValue;
    all += parseInt(num);
  }
  var words = new Map();
  var wdds = new Array(0);
  for(var i = 0; i < targets.length; i++){
    var wstr = '';
    for(var j = 0; true; j++){
      var word = targets[i].document.getElementById('word-' + j);
      var num = targets[i].document.getElementById('hit-' + j);
      if(word == null || num == null) break;
      word = word.firstChild.nodeValue;
      num = num.firstChild.nodeValue;
      wstr += '<span class="term">' + hesc(word) + ' (' + num + ')</span>';
      var sum = words.get(word);
      if(sum == null) sum = '0';
      sum = (parseInt(sum) + parseInt(num)) + '';
      words.put(word, sum);
    }
    var astr = targets[i].document.getElementById('all');
    astr = (astr == null) ? "0" : astr.firstChild.nodeValue;
    wdds.push('<dd class="ewords"><span class="term">' + hesc(labels[i]) + ':</span>' +
              '<span class="">' + astr + ' hits</span>' +
              '<span class="term">/</span>' + wstr + '</dd>');
  }
  println('<dl class="res">');
  println('<dt>Result:</dt>');
  println('<dd>');
  if(words.keys.length < 1){
    println('No effective word was extracted from the phrase.');
  } else if(all < 1){
    println('No document hits.');
  } else {
    println('<span class="term"><em id="all">' + all + '</em> hits</span>');
    println('<span class="term">/</span>');
    var keys = words.keys;
    for(var i = 0; i < keys.length; i++){
      println('<span class="term"><em>' + hesc(keys[i]) + '</em> (' +
              words.get(keys[i]) + ')</span>');
    }
  }
  println('</dd>');
  for(var i = 0; i < wdds.length; i++){
    println(wdds[i]);
  }
  println('</dl>');
  // collect result documents
  var docs = new Array(0);
  for(var i = 0; i < targets.length; i++){
    var tdocs = targets[i].document.getElementsByTagName('dl');
    for(var j = 0; j < tdocs.length; j++){
      if(tdocs[j].getAttributeNode('class').value != 'doc') continue;
      // get the URI and the title
      var title = '';
      var uri = '';
      var ancs = tdocs[j].getElementsByTagName('a');
      for(var k = 0; k < ancs.length; k++){
        if(ancs[k].getAttributeNode('class').value == 'title'){
          uri = ancs[k].getAttributeNode('href').value;
          title = ancs[k].firstChild.nodeValue;
          break;
        }
      }
      // get the score
      var score = '';
      var spans = tdocs[j].getElementsByTagName('span');
      for(var k = 0; k < spans.length; k++){
        if(spans[k].getAttributeNode('class').value == 'pt'){
          score = spans[k].firstChild.nodeValue;
          break;
        }
      }
      // get other attributes
      var ems = tdocs[j].getElementsByTagName('em');
      var author = '';
      var date = '';
      var type = '';
      var enc = '';
      var size = '';
      for(var k = 0; k < ems.length; k++){
        if(ems[k].getAttributeNode('class').value == 'author'){
          author = ems[k].firstChild.nodeValue;
        } else if(ems[k].getAttributeNode('class').value == 'date'){
          date = ems[k].firstChild.nodeValue;
        } else if(ems[k].getAttributeNode('class').value == 'type'){
          type = ems[k].firstChild.nodeValue;
        } else if(ems[k].getAttributeNode('class').value == 'encoding'){
          enc = ems[k].firstChild.nodeValue;
        } else if(ems[k].getAttributeNode('class').value == 'size'){
          size = ems[k].firstChild.nodeValue;
        }
      }
      // get the summary
      var sumnode = null;
      var dds = tdocs[j].getElementsByTagName('dd');
      for(var k = 0; k < dds.length; k++){
        var cls = dds[k].getAttributeNode('class');
        if(cls != null && cls.value == 'summary'){
          sumnode = dds[k];
        }
      }
      if(sumnode != null){
        var navis = sumnode.getElementsByTagName('span');
        while(navis.length > 0){
          navis[0].parentNode.removeChild(navis[0]);
        }
      }
      // add it to the list
      if(uri != null && uri.length > 0)
        docs.push(new ResultDoc(j, labels[i], uri, title, score,
                                author, date, type, enc, size, sumnode));
    }
  }
  // sort the result
  docs.sort(comparedocs);
  // show result documents
  for(var i = skip; i < docs.length && i < max + skip; i++){
    var label = hesc(docs[i].label);
    var uri = hesc(docs[i].uri);
    var title = hesc(docs[i].title);
    var score = docs[i].score;
    var author = hesc(docs[i].author);
    var date = hesc(docs[i].date);
    var type = hesc(docs[i].type);
    var enc = hesc(docs[i].enc);
    var size = hesc(docs[i].size);
    var sum = docs[i].sumnode.innerHTML;
    println('<dl class="doc">');
    println('<dt>' +
            '<span class="term">' + (i + 1) + ':</span>' +
            '<span class="term"><a href="' + uri + '" target="_blank" class="title">' + title +
            '</a></span>' +
            '<span class="term">(' + label + ')</span>' +
            '<span class="term">(<span class="pt">' + score + '</span> pt.)</span>' +
            '</dt>');
    if(sumnode != null) println('<dd class="summary">' + sum + '</dd>');
    println('<dd>' +
            (author.length < 1 ? '' :
             ('<span class="term">Author: <em class="author">' + author + '</em></span>')) +
            (date.length < 1 ? '' :
             ('<span class="term">Date: <em class="date">' + date + '</em></span>')) +
            (type.length < 1 ? '' :
             ('<span class="term">Type: <em class="type">' + type + '</em></span>')) +
            (enc.length < 1 ? '' :
             ('<span class="term">Encoding: <em class="encoding">' + enc + '</em></span>')) +
            (size.length < 1 ? '' :
             ('<span class="term">Size: <em class="size">' + size + '</em></span>')) +
            '</dd>');
    println('<dd><span class="term">URI: <a href="' + uri + '" class="uri">'
            + uri + '</a></span></dd>');
    println('</dl>');
  }
  // show paging navigations
  var tcstr = '';
  var tcnum = 1;
  var inputs = parent.parent.iform.document.getElementsByTagName('input');
  for(var i = 0; i < inputs.length; i++){
    if(inputs[i].getAttributeNode('type').value != 'checkbox') continue;
    if(inputs[i].checked) tcstr += '&tc' + tcnum + '=on';
    tcnum++;
  }
  println('<div class="paging" id="paging">');
  if(skip > 0){
    println('<span class="term">');
    println('<a href="result.html?phrase=' + phrase + '&max=' + max + '&skip=' + (skip - max) +
            tcstr + '#paging" class="navi" target="_parent">PREV</a>');
    println('</span>');
  } else {
    println('<span class="term">');
    println('<span class="disabled">PREV</span>');
    println('</span>');
  }
  if(all < docs.length) all = docs.length;
  if(skip + max < all){
    println('<span class="term">');
    println('<a href="result.html?phrase=' + phrase + '&max=' + max + '&skip=' + (skip + max) +
            tcstr + '" class="navi" target="_parent">NEXT</a>');
    println('</span>');
  } else {
    println('<span class="term">');
    println('<span class="disabled">NEXT</span>');
    println('</span>');
  }
  println('</div>');
  println('<div class="version">' + hesc(navigator.userAgent) + '</div>');
}



/* END OF FILE */
