/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "Python/esys/lsm/TriggerPrmsPy.h"

namespace esys
{
  namespace lsm
  {
    MaxTriggerPrmsPy::MaxTriggerPrmsPy(double on,double off,int buff,int tail)
    {
      trig_on_value=on;
      trig_off_value=off;
      buff_size=buff;
      tail_size=tail;
    }

    using boost::python::arg;
    void exportTriggerPrms()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      boost::python::class_<MaxTriggerPrmsPy>(
	 "MaxTriggerPrms",
	 "Parameter class for max trigger",
	 boost::python::init<double,double,int,int>((arg("on_value"),arg("off_value"),arg("buffer_size"),arg("tail_size"))));
	 					    
    }
  } // namespace lsm
} // namespace esys
