/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __SCALAR_INTERACTION_FIELD_SLAVE_H
#define __SCALAR_INTERACTION_FIELD_SLAVE_H

// -- project includes --
#include "Fields/InteractionFieldSlave.h"

template <typename I> class TParallelInteractionStorage;
class TML_Comm;

/*!
  \class ScalarInteractionFieldSlave
  \brief class for slave part of scalar field defined on the interactions

  \author Steffen Abe
  $Revision$
  $Date$
*/
template <typename T>
class ScalarInteractionFieldSlave : public InteractionFieldSlave<T>
{
protected:
  virtual void SendDataFull();
  virtual void SendDataFull2();
  virtual void SendDataWithID();
  virtual void SendDataSum();
  virtual void SendDataMax();

 protected:
  typename T::ScalarFieldFunction m_rdf;

 public:
  ScalarInteractionFieldSlave(TML_Comm*,TParallelInteractionStorage<T>*,typename T::ScalarFieldFunction);
};

#include "Fields/ScalarInteractionFieldSlave.hpp"

#endif //__SCALAR_INTERACTION_FIELD_SLAVE_H
