/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2014 by The University of Queensland //
// Centre for Geoscience Computing                         //
// http://earth.uq.edu.au/centre-geoscience-computing      //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include "Foundation/console.h"
#include "Foundation/Counter.h"

//--- IO includes ---
#include <iostream>
#include <cstdio>
#include <fstream>
#include <sstream>
#include <cstring>

using std::stringstream;
using std::cout;


#ifdef _ENABLE_DEBUG_FILE
FCon console;
#else 
Con console(&cout) ;
#endif // _ENABLE_DEBUG_FILE
BasicCon tconsole(&cout) ;

int BasicCon::VLevel = Con::info ;
bool BasicCon::mute = false ;
bool BasicCon::quiet = false ;
bool BasicCon::timing = false ;

BasicCon::BasicCon(ostream *Ios) 
{
  os = Ios ;
  CurBuffer = new char[1024] ;
}    

BasicCon::BasicCon() 
{
  CurBuffer = new char[1024] ;
}    



BasicCon::~BasicCon() {
  if (CurBuffer) {
    delete [] CurBuffer ;
  }
}

void BasicCon::SetOStream(ostream *Ios) 
{
  os = Ios ;
}    

/*!
  output stream on Output stream if not quiet
  \param str_os stream to output
*/  
void BasicCon::process(ostringstream *str_os) {
    if (!quiet) {
      *os << str_os->str() ;
      os->flush() ;
    }
}


BasicCon &  BasicCon::operator<<(const char* s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}


BasicCon &  BasicCon::operator<<(char s){
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(short s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}


BasicCon &  BasicCon::operator<<(int s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}


BasicCon &  BasicCon::operator<<(long s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}


BasicCon &  BasicCon::operator<<(float s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}


BasicCon &  BasicCon::operator<<(double s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(unsigned char s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(unsigned short s){
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(unsigned int s){
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(unsigned long s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(void* s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(Vec3 s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(const Matrix3& m) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << m << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(CCounter &s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(CCounterList &s) {
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

BasicCon &  BasicCon::operator<<(const string &s) 
{
    if (mute) return *this ;
    ostringstream str_os ;
    str_os << s << '\0' ;
    process(&str_os) ;

    return *this ;
}

void BasicCon::SetVerbose(int vl) {
  VLevel = vl ;
}

/*!
  Show header before output lines in h is true
  \param level string of character to output
  \param h if true will ouput the string level
*/
void BasicCon::show(char *level,bool h) {
  flush() ;
  if (h) {
    *this << "[" << level << "] " ;
  }
}

BasicCon & BasicCon::Critical(bool h) 
{
  if ( VLevel <= critical) {
    mute = false ;
    show("crt",h) ;
  } else {
    mute = true ;
  }
  return *this ;
}

BasicCon & BasicCon::Error(bool h) 
{
  if ( VLevel <= err) {
    mute = false ;
    show("err",h) ;
  } else {
    mute = true ;
  }
  return *this ;
}

BasicCon & BasicCon::Warning(bool h) 
{
  if ( VLevel <= warning) {
    mute = false ;
    show("wrn",h) ;
  } else {
    mute = true ;
  }
  return *this ;
}

BasicCon & BasicCon::Message(bool h) 
{
  if ( VLevel <= msg) {
    mute = false ;
    show("msg",h) ;
  } else {
    mute = true ;
  }
  return *this ;
}

BasicCon & BasicCon::Info(bool h) 
{
  if ( VLevel <= info) {
    mute = false ;
    show("inf",h) ;
  } else {
    mute = true ;
  }
  return *this ;
}

BasicCon & BasicCon::Debug(bool h) 
{
  if ( VLevel <= dbg) {
    mute = false ;
    show("dbg",h) ;
  } else {
    mute = true ;
  }
  return *this ;
}

BasicCon & BasicCon::XDebug(bool h) 
{
  if ( VLevel < dbg) {
    mute = false ;
    show("xbg",h) ;
  } else {
    mute = true ;
  }
  return *this ;
}

BasicCon & BasicCon::Timing(bool h) 
{
  if ( timing ) {
    mute = false ;
    show("tme",h) ;
  } else {
    mute = true ;
  }
  return *this ;
}


void BasicCon::flush() {
    os->flush() ;
}

/********************************************************************************/
/* class Con with history & sub-view for display				*/
/* 										*/
/* Description:									*/
/*   Handle message ouput on the console					*/
/********************************************************************************/

#include <sys/types.h>
#include <unistd.h>

Con::Con()
{
  CurCol=0 ;
}

Con::Con(ostream *Ios) : BasicCon(Ios) {
    CurCol=0 ;
}    

Con::~Con() {
}

void Con::process(ostringstream *str_os) {
    const char *str ;
    int len ;
    int i ;
	
    BasicCon::process(str_os) ;
    str = (str_os->str()).c_str() ;
    len = strlen(str) ;
    for (i=0; i<len; i++) {
		if (str[i] != '\n') {
			if (CurCol < 4095) {
				Buffer[CurCol] = str[i] ;
				CurCol ++ ;
                Buffer[CurCol] = '\0' ;
			}
		} else {
			if (CurCol < 4094) {
#ifdef _WINDOWS
				Buffer[CurCol++] = '\r' ;
#endif
				Buffer[CurCol++] = '\n' ;
			}
            Buffer[CurCol] = '\0' ;
			cout.flush() ;
			ConsoleWindow::Update() ;
		}
    }
}

char *Con::GetLast(char *buff) { 
    strcpy(buff,Buffer) ;
    CurCol = 0 ;
    Buffer[0]='\0' ;
    return buff;
} 

ConsoleWindow* ConsoleWindow::Window = NULL ;

void ConsoleWindow::Update() {
  if (Window) {
      Window->UpdateCon() ;
  }
}

FCon::FCon() : Con()
{
  // get pid
  pid_t my_pid=getpid();
  stringstream fnstr;
  fnstr << "debug.con." << my_pid;
  m_debugfile.open(fnstr.str().c_str());
  os=&m_debugfile;

}

FCon::~FCon() {
  m_debugfile.close();
}
