/* DO NOT EDIT
 * This dissector is autogenerated
 */

/* packet-dcerpc-efs.c
 * Routines for EFS packet disassembly
 *   ronnie sahlberg 2005
 * Autogenerated based on the IDL definitions by
 *   Jean-Baptiste Marchand
 *
 * $Id: packet-dcerpc-efs.c 13806 2005-03-19 09:11:56Z sahlberg $
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@ethereal.com>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib.h>
#include <string.h>

#include <epan/packet.h>
#include "packet-dcerpc.h"
#include "packet-dcerpc-nt.h"
#include "packet-windows-common.h"
#include "packet-dcerpc-efs.h"

static int proto_efs = -1;


/* INCLUDED FILE : ETH_HF */
static int hf_efs_opnum = -1;
static int hf_efs_rc = -1;
static int hf_efs_EfsRpcOpenFileRaw_pvContext = -1;
static int hf_efs_EfsRpcOpenFileRaw_FileName = -1;
static int hf_efs_EfsRpcOpenFileRaw_Flags = -1;
static int hf_efs_EfsRpcReadFileRaw_pvContext = -1;
static int hf_efs_EfsRpcWriteFileRaw_pvContext = -1;
static int hf_efs_EfsRpcCloseRaw_pvContext = -1;
static int hf_efs_EfsRpcEncryptFileSrv_Filename = -1;
static int hf_efs_EfsRpcDecryptFileSrv_FileName = -1;
static int hf_efs_EfsRpcDecryptFileSrv_Reserved = -1;
static int hf_efs_EFS_HASH_BLOB_cbData = -1;
static int hf_efs_EFS_HASH_BLOB_pbData = -1;
static int hf_efs_ENCRYPTION_CERTIFICATE_HASH_cbTotalLength = -1;
static int hf_efs_ENCRYPTION_CERTIFICATE_HASH_pUserSid = -1;
static int hf_efs_ENCRYPTION_CERTIFICATE_HASH_pHash = -1;
static int hf_efs_ENCRYPTION_CERTIFICATE_HASH_lpDisplayInformation = -1;
static int hf_efs_ENCRYPTION_CERTIFICATE_HASH_LIST_nCert_Hash = -1;
static int hf_efs_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers = -1;
static int hf_efs_EfsRpcQueryUsersOnFile_FileName = -1;
static int hf_efs_EfsRpcQueryUsersOnFile_pUsers = -1;
static int hf_efs_EfsRpcQueryRecoveryAgents_FileName = -1;
static int hf_efs_EfsRpcQueryRecoveryAgents_pRecoveryAgents = -1;
static int hf_efs_EfsRpcRemoveUsersFromFile_FileName = -1;
static int hf_efs_EfsRpcAddUsersToFile_FileName = -1;
static int hf_efs_EFS_CERTIFICATE_BLOB_dwCertEncodingType = -1;
static int hf_efs_EFS_CERTIFICATE_BLOB_cbData = -1;
static int hf_efs_EFS_CERTIFICATE_BLOB_pbData = -1;
static int hf_efs_ENCRYPTION_CERTIFICATE_TotalLength = -1;
static int hf_efs_ENCRYPTION_CERTIFICATE_pUserSid = -1;
static int hf_efs_ENCRYPTION_CERTIFICATE_pCertBlob = -1;
static int hf_efs_EfsRpcSetFileEncryptionKey_pEncryptionCertificate = -1;
/* END OF INCLUDED FILE : ETH_HF */





/* INCLUDED FILE : ETH_ETT */
static gint ett_efs = -1;
static gint ett_efs_EFS_HASH_BLOB = -1;
static gint ett_efs_ENCRYPTION_CERTIFICATE_HASH = -1;
static gint ett_efs_ENCRYPTION_CERTIFICATE_HASH_LIST = -1;
static gint ett_efs_EFS_CERTIFICATE_BLOB = -1;
static gint ett_efs_ENCRYPTION_CERTIFICATE = -1;
/* END OF INCLUDED FILE : ETH_ETT */





/* INCLUDED FILE : ETH_CODE */
static e_uuid_t uuid_dcerpc_efs = {
    0xc681d488, 0xd850, 0x11d0,
    { 0x8c, 0x52, 0x00, 0xc0, 0x4f, 0xd9, 0x0f, 0x7e}
};

static guint16 ver_efs = 1;


static e_ctx_hnd policy_hnd;
static proto_item *hnd_item;

static int
efs_dissect_policy_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param)
{
    offset = dissect_nt_policy_hnd(tvb, offset, pinfo, tree, drep,
                   hf_index, &policy_hnd, &hnd_item,
                   param&0x01, param&0x02);
    return offset;
}

static int
efs_dissect_EfsRpcOpenFileRaw_pvContext(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcOpenFileRaw_pvContext, param);
    return offset;
}

static int
ref_efs_dissect_EfsRpcOpenFileRaw_pvContext(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_EfsRpcOpenFileRaw_pvContext, NDR_POINTER_REF, "pvContext", -1);
    return offset;
}


static int
efs_dissect_unistr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_cvstring(tvb, offset, pinfo, tree, drep, 2, hf_index, FALSE, NULL);
    return offset;
}

static int
efs_dissect_EfsRpcOpenFileRaw_FileName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcOpenFileRaw_FileName, param);
    return offset;
}


static int
efs_dissect_long(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
efs_dissect_EfsRpcOpenFileRaw_Flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_long(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcOpenFileRaw_Flags, param);
    return offset;
}


static int
efs_dissect_EfsRpcOpenFileRaw_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=efs_dissect_EfsRpcOpenFileRaw_FileName(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=efs_dissect_EfsRpcOpenFileRaw_Flags(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcOpenFileRaw_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_efs_dissect_EfsRpcOpenFileRaw_pvContext(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
static int
efs_dissect_EfsRpcReadFileRaw_pvContext(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcReadFileRaw_pvContext, param);
    return offset;
}

static int
ref_efs_dissect_EfsRpcReadFileRaw_pvContext(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_EfsRpcReadFileRaw_pvContext, NDR_POINTER_REF, "pvContext", -1);
    return offset;
}


static int
efs_dissect_EfsRpcReadFileRaw_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_efs_dissect_EfsRpcReadFileRaw_pvContext(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcReadFileRaw_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
static int
efs_dissect_EfsRpcWriteFileRaw_pvContext(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcWriteFileRaw_pvContext, param);
    return offset;
}

static int
ref_efs_dissect_EfsRpcWriteFileRaw_pvContext(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_EfsRpcWriteFileRaw_pvContext, NDR_POINTER_REF, "pvContext", -1);
    return offset;
}


static int
efs_dissect_EfsRpcWriteFileRaw_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_efs_dissect_EfsRpcWriteFileRaw_pvContext(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcWriteFileRaw_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
static int
efs_dissect_EfsRpcCloseRaw_pvContext(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcCloseRaw_pvContext, param);
    return offset;
}

static int
ref_efs_dissect_EfsRpcCloseRaw_pvContext(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_EfsRpcCloseRaw_pvContext, NDR_POINTER_REF, "pvContext", -1);
    return offset;
}


static int
efs_dissect_EfsRpcCloseRaw_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_efs_dissect_EfsRpcCloseRaw_pvContext(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcCloseRaw_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_efs_dissect_EfsRpcCloseRaw_pvContext(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
static int
efs_dissect_EfsRpcEncryptFileSrv_Filename(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcEncryptFileSrv_Filename, param);
    return offset;
}


static int
efs_dissect_EfsRpcEncryptFileSrv_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=efs_dissect_EfsRpcEncryptFileSrv_Filename(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcEncryptFileSrv_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
static int
efs_dissect_EfsRpcDecryptFileSrv_FileName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcDecryptFileSrv_FileName, param);
    return offset;
}

static int
efs_dissect_EfsRpcDecryptFileSrv_Reserved(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_long(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcDecryptFileSrv_Reserved, param);
    return offset;
}


static int
efs_dissect_EfsRpcDecryptFileSrv_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=efs_dissect_EfsRpcDecryptFileSrv_FileName(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=efs_dissect_EfsRpcDecryptFileSrv_Reserved(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcDecryptFileSrv_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
static int
efs_dissect_EFS_HASH_BLOB_cbData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_long(tvb, offset, pinfo, tree, drep, hf_efs_EFS_HASH_BLOB_cbData, param);
    return offset;
}


static int
efs_dissect_uint8(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint8(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
efs_dissect_EFS_HASH_BLOB_pbData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_uint8(tvb, offset, pinfo, tree, drep, hf_efs_EFS_HASH_BLOB_pbData, param);
    return offset;
}

static int
ucarray_efs_dissect_EFS_HASH_BLOB_pbData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, efs_dissect_EFS_HASH_BLOB_pbData);
    return offset;
}

static int
unique_ucarray_efs_dissect_EFS_HASH_BLOB_pbData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_efs_dissect_EFS_HASH_BLOB_pbData, NDR_POINTER_UNIQUE, "pbData", -1);
    return offset;
}


int
efs_dissect_EFS_HASH_BLOB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_efs_EFS_HASH_BLOB);
    }

    offset=efs_dissect_EFS_HASH_BLOB_cbData(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_efs_dissect_EFS_HASH_BLOB_pbData(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
efs_dissect_ENCRYPTION_CERTIFICATE_HASH_cbTotalLength(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_long(tvb, offset, pinfo, tree, drep, hf_efs_ENCRYPTION_CERTIFICATE_HASH_cbTotalLength, param);
    return offset;
}


static int
efs_dissect_SID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param)
{
    dcerpc_info *di = (dcerpc_info *)pinfo->private_data;

    di->hf_index=hf_index;
    offset=dissect_ndr_nt_SID_with_options(tvb, offset, pinfo, tree, drep, param);
    return offset;
}

static int
efs_dissect_ENCRYPTION_CERTIFICATE_HASH_pUserSid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_SID(tvb, offset, pinfo, tree, drep, hf_efs_ENCRYPTION_CERTIFICATE_HASH_pUserSid, param);
    return offset;
}

static int
unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_pUserSid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_ENCRYPTION_CERTIFICATE_HASH_pUserSid, NDR_POINTER_UNIQUE, "pUserSid", -1);
    return offset;
}

static int
efs_dissect_ENCRYPTION_CERTIFICATE_HASH_pHash(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_EFS_HASH_BLOB(tvb, offset, pinfo, tree, drep, hf_efs_ENCRYPTION_CERTIFICATE_HASH_pHash, param);
    return offset;
}

static int
unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_pHash(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_ENCRYPTION_CERTIFICATE_HASH_pHash, NDR_POINTER_UNIQUE, "pHash", -1);
    return offset;
}

static int
efs_dissect_ENCRYPTION_CERTIFICATE_HASH_lpDisplayInformation(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_efs_ENCRYPTION_CERTIFICATE_HASH_lpDisplayInformation, param);
    return offset;
}

static int
unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_lpDisplayInformation(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_ENCRYPTION_CERTIFICATE_HASH_lpDisplayInformation, NDR_POINTER_UNIQUE, "lpDisplayInformation", -1);
    return offset;
}


int
efs_dissect_ENCRYPTION_CERTIFICATE_HASH(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_efs_ENCRYPTION_CERTIFICATE_HASH);
    }

    offset=efs_dissect_ENCRYPTION_CERTIFICATE_HASH_cbTotalLength(tvb, offset, pinfo, tree, drep);

    offset=unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_pUserSid(tvb, offset, pinfo, tree, drep);

    offset=unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_pHash(tvb, offset, pinfo, tree, drep);

    offset=unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_lpDisplayInformation(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST_nCert_Hash(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_long(tvb, offset, pinfo, tree, drep, hf_efs_ENCRYPTION_CERTIFICATE_HASH_LIST_nCert_Hash, param);
    return offset;
}

static int
efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_ENCRYPTION_CERTIFICATE_HASH(tvb, offset, pinfo, tree, drep, hf_efs_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers, param);
    return offset;
}

static int
unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers, NDR_POINTER_UNIQUE, "pUsers", -1);
    return offset;
}

static int
ucarray_unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers);
    return offset;
}

static int
unique_ucarray_unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers, NDR_POINTER_UNIQUE, "pUsers", -1);
    return offset;
}


int
efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_efs_ENCRYPTION_CERTIFICATE_HASH_LIST);
    }

    offset=efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST_nCert_Hash(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_unique_efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
efs_dissect_EfsRpcQueryUsersOnFile_FileName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcQueryUsersOnFile_FileName, param);
    return offset;
}

static int
efs_dissect_EfsRpcQueryUsersOnFile_pUsers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcQueryUsersOnFile_pUsers, param);
    return offset;
}

static int
unique_efs_dissect_EfsRpcQueryUsersOnFile_pUsers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_EfsRpcQueryUsersOnFile_pUsers, NDR_POINTER_UNIQUE, "pUsers", -1);
    return offset;
}

static int
ref_unique_efs_dissect_EfsRpcQueryUsersOnFile_pUsers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, unique_efs_dissect_EfsRpcQueryUsersOnFile_pUsers, NDR_POINTER_REF, "pUsers", -1);
    return offset;
}


static int
efs_dissect_EfsRpcQueryUsersOnFile_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=efs_dissect_EfsRpcQueryUsersOnFile_FileName(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcQueryUsersOnFile_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_unique_efs_dissect_EfsRpcQueryUsersOnFile_pUsers(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
static int
efs_dissect_EfsRpcQueryRecoveryAgents_FileName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcQueryRecoveryAgents_FileName, param);
    return offset;
}

static int
efs_dissect_EfsRpcQueryRecoveryAgents_pRecoveryAgents(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_ENCRYPTION_CERTIFICATE_HASH_LIST(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcQueryRecoveryAgents_pRecoveryAgents, param);
    return offset;
}

static int
unique_efs_dissect_EfsRpcQueryRecoveryAgents_pRecoveryAgents(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_EfsRpcQueryRecoveryAgents_pRecoveryAgents, NDR_POINTER_UNIQUE, "pRecoveryAgents", -1);
    return offset;
}

static int
ref_unique_efs_dissect_EfsRpcQueryRecoveryAgents_pRecoveryAgents(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, unique_efs_dissect_EfsRpcQueryRecoveryAgents_pRecoveryAgents, NDR_POINTER_REF, "pRecoveryAgents", -1);
    return offset;
}


static int
efs_dissect_EfsRpcQueryRecoveryAgents_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=efs_dissect_EfsRpcQueryRecoveryAgents_FileName(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcQueryRecoveryAgents_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_unique_efs_dissect_EfsRpcQueryRecoveryAgents_pRecoveryAgents(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
static int
efs_dissect_EfsRpcRemoveUsersFromFile_FileName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcRemoveUsersFromFile_FileName, param);
    return offset;
}


static int
efs_dissect_EfsRpcRemoveUsersFromFile_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=efs_dissect_EfsRpcRemoveUsersFromFile_FileName(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcRemoveUsersFromFile_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
static int
efs_dissect_EfsRpcAddUsersToFile_FileName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcAddUsersToFile_FileName, param);
    return offset;
}


static int
efs_dissect_EfsRpcAddUsersToFile_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=efs_dissect_EfsRpcAddUsersToFile_FileName(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcAddUsersToFile_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
static int
efs_dissect_EFS_CERTIFICATE_BLOB_dwCertEncodingType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_long(tvb, offset, pinfo, tree, drep, hf_efs_EFS_CERTIFICATE_BLOB_dwCertEncodingType, param);
    return offset;
}

static int
efs_dissect_EFS_CERTIFICATE_BLOB_cbData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_long(tvb, offset, pinfo, tree, drep, hf_efs_EFS_CERTIFICATE_BLOB_cbData, param);
    return offset;
}

static int
efs_dissect_EFS_CERTIFICATE_BLOB_pbData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_uint8(tvb, offset, pinfo, tree, drep, hf_efs_EFS_CERTIFICATE_BLOB_pbData, param);
    return offset;
}

static int
ucarray_efs_dissect_EFS_CERTIFICATE_BLOB_pbData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, efs_dissect_EFS_CERTIFICATE_BLOB_pbData);
    return offset;
}

static int
unique_ucarray_efs_dissect_EFS_CERTIFICATE_BLOB_pbData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_efs_dissect_EFS_CERTIFICATE_BLOB_pbData, NDR_POINTER_UNIQUE, "pbData", -1);
    return offset;
}


int
efs_dissect_EFS_CERTIFICATE_BLOB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_efs_EFS_CERTIFICATE_BLOB);
    }

    offset=efs_dissect_EFS_CERTIFICATE_BLOB_dwCertEncodingType(tvb, offset, pinfo, tree, drep);

    offset=efs_dissect_EFS_CERTIFICATE_BLOB_cbData(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_efs_dissect_EFS_CERTIFICATE_BLOB_pbData(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
efs_dissect_ENCRYPTION_CERTIFICATE_TotalLength(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_long(tvb, offset, pinfo, tree, drep, hf_efs_ENCRYPTION_CERTIFICATE_TotalLength, param);
    return offset;
}

static int
efs_dissect_ENCRYPTION_CERTIFICATE_pUserSid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_SID(tvb, offset, pinfo, tree, drep, hf_efs_ENCRYPTION_CERTIFICATE_pUserSid, param);
    return offset;
}

static int
unique_efs_dissect_ENCRYPTION_CERTIFICATE_pUserSid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_ENCRYPTION_CERTIFICATE_pUserSid, NDR_POINTER_UNIQUE, "pUserSid", -1);
    return offset;
}

static int
efs_dissect_ENCRYPTION_CERTIFICATE_pCertBlob(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_EFS_CERTIFICATE_BLOB(tvb, offset, pinfo, tree, drep, hf_efs_ENCRYPTION_CERTIFICATE_pCertBlob, param);
    return offset;
}

static int
unique_efs_dissect_ENCRYPTION_CERTIFICATE_pCertBlob(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_ENCRYPTION_CERTIFICATE_pCertBlob, NDR_POINTER_UNIQUE, "pCertBlob", -1);
    return offset;
}


int
efs_dissect_ENCRYPTION_CERTIFICATE(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_efs_ENCRYPTION_CERTIFICATE);
    }

    offset=efs_dissect_ENCRYPTION_CERTIFICATE_TotalLength(tvb, offset, pinfo, tree, drep);

    offset=unique_efs_dissect_ENCRYPTION_CERTIFICATE_pUserSid(tvb, offset, pinfo, tree, drep);

    offset=unique_efs_dissect_ENCRYPTION_CERTIFICATE_pCertBlob(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
efs_dissect_EfsRpcSetFileEncryptionKey_pEncryptionCertificate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=efs_dissect_ENCRYPTION_CERTIFICATE(tvb, offset, pinfo, tree, drep, hf_efs_EfsRpcSetFileEncryptionKey_pEncryptionCertificate, param);
    return offset;
}

static int
unique_efs_dissect_EfsRpcSetFileEncryptionKey_pEncryptionCertificate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, efs_dissect_EfsRpcSetFileEncryptionKey_pEncryptionCertificate, NDR_POINTER_UNIQUE, "pEncryptionCertificate", -1);
    return offset;
}


static int
efs_dissect_EfsRpcSetFileEncryptionKey_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=unique_efs_dissect_EfsRpcSetFileEncryptionKey_pEncryptionCertificate(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
efs_dissect_EfsRpcSetFileEncryptionKey_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}

static int
efs_dissect_EfsRpcNotSupported_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
efs_dissect_EfsRpcNotSupported_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}

static int
efs_dissect_EfsRpcFileKeyInfo_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
efs_dissect_EfsRpcFileKeyInfo_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}

static int
efs_dissect_EfsRpcDuplicateEncryptionInfoFile_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
efs_dissect_EfsRpcDuplicateEncryptionInfoFile_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_efs_rc, NULL);


   return offset;
}
/* END OF INCLUDED FILE : ETH_CODE */



void
proto_register_efs(void)
{
        static hf_register_info hf[] = {


/* INCLUDED FILE : ETH_HFARR */
        { &hf_efs_opnum,
          { "Operation", "efs.opnum", FT_UINT16, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_rc,
          { "Return code", "efs.rc", FT_UINT32, BASE_HEX,
          VALS(NT_errors), 0,
         "", HFILL }},

        { &hf_efs_EfsRpcOpenFileRaw_pvContext,
          { "pvContext", "efs.EfsRpcOpenFileRaw.pvContext", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcOpenFileRaw_FileName,
          { "FileName", "efs.EfsRpcOpenFileRaw.FileName", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcOpenFileRaw_Flags,
          { "Flags", "efs.EfsRpcOpenFileRaw.Flags", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcReadFileRaw_pvContext,
          { "pvContext", "efs.EfsRpcReadFileRaw.pvContext", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcWriteFileRaw_pvContext,
          { "pvContext", "efs.EfsRpcWriteFileRaw.pvContext", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcCloseRaw_pvContext,
          { "pvContext", "efs.EfsRpcCloseRaw.pvContext", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcEncryptFileSrv_Filename,
          { "Filename", "efs.EfsRpcEncryptFileSrv.Filename", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcDecryptFileSrv_FileName,
          { "FileName", "efs.EfsRpcDecryptFileSrv.FileName", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcDecryptFileSrv_Reserved,
          { "Reserved", "efs.EfsRpcDecryptFileSrv.Reserved", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EFS_HASH_BLOB_cbData,
          { "cbData", "efs.EFS_HASH_BLOB.cbData", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EFS_HASH_BLOB_pbData,
          { "pbData", "efs.EFS_HASH_BLOB.pbData", FT_UINT8, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_ENCRYPTION_CERTIFICATE_HASH_cbTotalLength,
          { "cbTotalLength", "efs.ENCRYPTION_CERTIFICATE_HASH.cbTotalLength", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_ENCRYPTION_CERTIFICATE_HASH_pUserSid,
          { "pUserSid", "efs.ENCRYPTION_CERTIFICATE_HASH.pUserSid", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_ENCRYPTION_CERTIFICATE_HASH_pHash,
          { "pHash", "efs.ENCRYPTION_CERTIFICATE_HASH.pHash", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_ENCRYPTION_CERTIFICATE_HASH_lpDisplayInformation,
          { "lpDisplayInformation", "efs.ENCRYPTION_CERTIFICATE_HASH.lpDisplayInformation", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_ENCRYPTION_CERTIFICATE_HASH_LIST_nCert_Hash,
          { "nCert_Hash", "efs.ENCRYPTION_CERTIFICATE_HASH_LIST.nCert_Hash", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_ENCRYPTION_CERTIFICATE_HASH_LIST_pUsers,
          { "pUsers", "efs.ENCRYPTION_CERTIFICATE_HASH_LIST.pUsers", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcQueryUsersOnFile_FileName,
          { "FileName", "efs.EfsRpcQueryUsersOnFile.FileName", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcQueryUsersOnFile_pUsers,
          { "pUsers", "efs.EfsRpcQueryUsersOnFile.pUsers", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcQueryRecoveryAgents_FileName,
          { "FileName", "efs.EfsRpcQueryRecoveryAgents.FileName", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcQueryRecoveryAgents_pRecoveryAgents,
          { "pRecoveryAgents", "efs.EfsRpcQueryRecoveryAgents.pRecoveryAgents", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcRemoveUsersFromFile_FileName,
          { "FileName", "efs.EfsRpcRemoveUsersFromFile.FileName", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcAddUsersToFile_FileName,
          { "FileName", "efs.EfsRpcAddUsersToFile.FileName", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EFS_CERTIFICATE_BLOB_dwCertEncodingType,
          { "dwCertEncodingType", "efs.EFS_CERTIFICATE_BLOB.dwCertEncodingType", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EFS_CERTIFICATE_BLOB_cbData,
          { "cbData", "efs.EFS_CERTIFICATE_BLOB.cbData", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EFS_CERTIFICATE_BLOB_pbData,
          { "pbData", "efs.EFS_CERTIFICATE_BLOB.pbData", FT_UINT8, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_ENCRYPTION_CERTIFICATE_TotalLength,
          { "TotalLength", "efs.ENCRYPTION_CERTIFICATE.TotalLength", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_ENCRYPTION_CERTIFICATE_pUserSid,
          { "pUserSid", "efs.ENCRYPTION_CERTIFICATE.pUserSid", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_ENCRYPTION_CERTIFICATE_pCertBlob,
          { "pCertBlob", "efs.ENCRYPTION_CERTIFICATE.pCertBlob", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_efs_EfsRpcSetFileEncryptionKey_pEncryptionCertificate,
          { "pEncryptionCertificate", "efs.EfsRpcSetFileEncryptionKey.pEncryptionCertificate", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

/* END OF INCLUDED FILE : ETH_HFARR */


	};

        static gint *ett[] = {


/* INCLUDED FILE : ETH_ETTARR */
        &ett_efs,
        &ett_efs_EFS_HASH_BLOB,
        &ett_efs_ENCRYPTION_CERTIFICATE_HASH,
        &ett_efs_ENCRYPTION_CERTIFICATE_HASH_LIST,
        &ett_efs_EFS_CERTIFICATE_BLOB,
        &ett_efs_ENCRYPTION_CERTIFICATE,
/* END OF INCLUDED FILE : ETH_ETTARR */


        };

        proto_efs = proto_register_protocol(
                "Microsoft Encrypted File System Service", 
		"EFS", "efs");
	proto_register_field_array(proto_efs, hf, array_length(hf));
        proto_register_subtree_array(ett, array_length(ett));
}

static dcerpc_sub_dissector function_dissectors[] = {


/* INCLUDED FILE : ETH_FT */
    { 0, "EfsRpcOpenFileRaw",
        efs_dissect_EfsRpcOpenFileRaw_request,
        efs_dissect_EfsRpcOpenFileRaw_response },
    { 1, "EfsRpcReadFileRaw",
        efs_dissect_EfsRpcReadFileRaw_request,
        efs_dissect_EfsRpcReadFileRaw_response },
    { 2, "EfsRpcWriteFileRaw",
        efs_dissect_EfsRpcWriteFileRaw_request,
        efs_dissect_EfsRpcWriteFileRaw_response },
    { 3, "EfsRpcCloseRaw",
        efs_dissect_EfsRpcCloseRaw_request,
        efs_dissect_EfsRpcCloseRaw_response },
    { 4, "EfsRpcEncryptFileSrv",
        efs_dissect_EfsRpcEncryptFileSrv_request,
        efs_dissect_EfsRpcEncryptFileSrv_response },
    { 5, "EfsRpcDecryptFileSrv",
        efs_dissect_EfsRpcDecryptFileSrv_request,
        efs_dissect_EfsRpcDecryptFileSrv_response },
    { 6, "EfsRpcQueryUsersOnFile",
        efs_dissect_EfsRpcQueryUsersOnFile_request,
        efs_dissect_EfsRpcQueryUsersOnFile_response },
    { 7, "EfsRpcQueryRecoveryAgents",
        efs_dissect_EfsRpcQueryRecoveryAgents_request,
        efs_dissect_EfsRpcQueryRecoveryAgents_response },
    { 8, "EfsRpcRemoveUsersFromFile",
        efs_dissect_EfsRpcRemoveUsersFromFile_request,
        efs_dissect_EfsRpcRemoveUsersFromFile_response },
    { 9, "EfsRpcAddUsersToFile",
        efs_dissect_EfsRpcAddUsersToFile_request,
        efs_dissect_EfsRpcAddUsersToFile_response },
    { 10, "EfsRpcSetFileEncryptionKey",
        efs_dissect_EfsRpcSetFileEncryptionKey_request,
        efs_dissect_EfsRpcSetFileEncryptionKey_response },
    { 11, "EfsRpcNotSupported",
        efs_dissect_EfsRpcNotSupported_request,
        efs_dissect_EfsRpcNotSupported_response },
    { 12, "EfsRpcFileKeyInfo",
        efs_dissect_EfsRpcFileKeyInfo_request,
        efs_dissect_EfsRpcFileKeyInfo_response },
    { 13, "EfsRpcDuplicateEncryptionInfoFile",
        efs_dissect_EfsRpcDuplicateEncryptionInfoFile_request,
        efs_dissect_EfsRpcDuplicateEncryptionInfoFile_response },
/* END OF INCLUDED FILE : ETH_FT */


	{ 0, NULL, NULL, NULL },
};

void
proto_reg_handoff_efs(void)
{


/* INCLUDED FILE : ETH_HANDOFF */
    dcerpc_init_uuid(proto_efs, ett_efs,
        &uuid_dcerpc_efs, ver_efs,
        function_dissectors, hf_efs_opnum);
/* END OF INCLUDED FILE : ETH_HANDOFF */


}

