/* privileges.h
 * Declarations of routines for handling privileges.
 *
 * $Id: privileges.h 17183 2006-02-06 12:21:31Z jmayer $
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@ethereal.com>
 * Copyright 2006 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*
 * Called when the program starts, to save whatever credential information
 * we'll need later.
 */
extern void get_credential_info(void);

/*
 * Was this program started with special privileges?
 */
extern gboolean started_with_special_privs(void);

/*
 * Permanently relinquish special privileges.
 */
extern void relinquish_special_privs_perm(void);
