//
// This is cut-n-paste code
//
// Author:
//   Pierre-Luc Beaudoin <pierre-luc.beaudoin@novopia.com>
//

#include "manager.h"

#include <string.h>
#include <ethos/ethos.h>
#include <gconf/gconf-client.h>

static EthosManager *default_manager = NULL;

#define SAMPLE_MANAGER_GET_PRIVATE(object) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((object), \
        SAMPLE_TYPE_MANAGER, \
        SampleManagerPrivate))

G_DEFINE_TYPE (SampleManager, sample_manager, ETHOS_TYPE_MANAGER);

struct _SampleManagerPrivate
{
  GConfClient *client;
};

static void
sample_manager_init (SampleManager *self)
{
  self->priv = SAMPLE_MANAGER_GET_PRIVATE (self);
}

static void
sample_manager_dispose (GObject *object)
{
  G_OBJECT_CLASS (sample_manager_parent_class)->dispose (object);
}

static void
sample_manager_finalize (GObject *object)
{
  G_OBJECT_CLASS (sample_manager_parent_class)->finalize (object);
}

static GObject *
sample_manager_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam *construct_params)
{
  GObject *object;

  if (default_manager == NULL)
    {
      object = G_OBJECT_CLASS (sample_manager_parent_class)->constructor (
      type, n_construct_properties, construct_params);

      default_manager = ETHOS_MANAGER (object);
      g_object_add_weak_pointer (object, (gpointer) &default_manager);
    }
  else
    {
      object = g_object_ref (default_manager);
    }

  return object;
}

static void
gconf_list_free (GSList *conf)
{
  GSList *iter;

  for (iter = conf; iter; iter = iter->next)
    g_free (iter->data);

  g_slist_free (conf);
}

static gboolean
is_enabled (GSList *conf, EthosPluginInfo *plugin)
{
  GSList *iter;

  for (iter = conf; iter; iter = iter->next)
    {
      if (strcmp (iter->data, ethos_plugin_info_get_id (plugin)) == 0)
        return TRUE;
    }

  return FALSE;
}

#define SAMPLE_CONF_PLUGINS_ACTIVE_PLUGINS "/apps/sample/plugins/active-plugins"

static void
sample_manager_plugin_loaded (EthosManager    *emanager,
                                 EthosPluginInfo *plugin_info)
{
  GSList *conf_list;
  GError *error = NULL;
  SampleManager *manager = SAMPLE_MANAGER (emanager);

  conf_list = gconf_client_get_list (manager->priv->client,
      SAMPLE_CONF_PLUGINS_ACTIVE_PLUGINS,
      GCONF_VALUE_STRING,
      &error);

  if (error)
    {
      g_warning ("gconf: %s", error->message);
      g_error_free (error);
      error = NULL;
      return;
    }

  /* if the plugin is already in the list, stop */
  if (is_enabled (conf_list, plugin_info))
    {
      gconf_list_free (conf_list);
      return;
    }

  conf_list = g_slist_append (conf_list, g_strdup (ethos_plugin_info_get_id (plugin_info)));

  gconf_client_set_list (manager->priv->client,
      SAMPLE_CONF_PLUGINS_ACTIVE_PLUGINS,
      GCONF_VALUE_STRING,
      conf_list,
      &error);

  if (error)
    {
      g_warning ("gconf: %s", error->message);
      g_error_free (error);
      error = NULL;
    }

  gconf_list_free (conf_list);
}

static void
sample_manager_plugin_unloaded (EthosManager    *emanager,
                                   EthosPluginInfo *plugin_info)
{
  GSList *conf_list;
  GSList *iter;
  GError *error = NULL;
  SampleManager *manager = SAMPLE_MANAGER (emanager);

  conf_list = gconf_client_get_list (manager->priv->client,
      SAMPLE_CONF_PLUGINS_ACTIVE_PLUGINS,
      GCONF_VALUE_STRING,
      &error);

  if (error)
    {
      g_warning ("gconf: %s", error->message);
      g_error_free (error);
      error = NULL;
      return;
    }

  for (iter = conf_list; iter; iter = iter->next)
    {
      if (strcmp (iter->data, ethos_plugin_info_get_id (plugin_info)) == 0)
        conf_list = g_slist_delete_link (conf_list, iter);
    }

  gconf_client_set_list (manager->priv->client,
      SAMPLE_CONF_PLUGINS_ACTIVE_PLUGINS,
      GCONF_VALUE_STRING,
      conf_list,
      &error);

  if (error)
    {
      g_warning ("gconf: %s", error->message);
      g_error_free (error);
      error = NULL;
    }

  gconf_list_free (conf_list);
}

static void
sample_manager_initialized (EthosManager *emanager)
{
  GList  *list,
         *iter;
  GSList *conf_list;
  GError *error = NULL;
  SampleManager *manager = SAMPLE_MANAGER (emanager);

  g_return_if_fail (ETHOS_IS_MANAGER (manager));

  manager->priv->client = gconf_client_get_default ();
  conf_list = gconf_client_get_list (manager->priv->client,
      SAMPLE_CONF_PLUGINS_ACTIVE_PLUGINS,
      GCONF_VALUE_STRING,
      &error);

  if (error)
    {
      g_warning ("gconf: %s", error->message);
      g_error_free (error);
      error = NULL;
    }

  list = ethos_manager_get_plugin_info (emanager);
  for (iter = list; iter; iter = iter->next)
    {
      if (ethos_plugin_info_get_active (iter->data))
        {
          continue;
        }
      else if (is_enabled (conf_list, iter->data) &&
               !ethos_manager_load_plugin (emanager, iter->data, &error))
        {
          g_warning ("%s: %s",
                     ethos_plugin_info_get_id (iter->data),
                     error ? error->message : "Error loading");

          if (error)
            {
              ethos_plugin_info_add_error (iter->data, error);
              g_error_free (error);
              error = NULL;
            }
        }
    }

  g_list_free (list);
  gconf_list_free (conf_list);
}

static void
sample_manager_class_init (SampleManagerClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  EthosManagerClass *ethos_class = ETHOS_MANAGER_CLASS (klass);

  object_class->constructor = sample_manager_constructor;
  object_class->dispose = sample_manager_dispose;
  object_class->finalize = sample_manager_finalize;

  ethos_class->initialized = sample_manager_initialized;
  ethos_class->plugin_loaded = sample_manager_plugin_loaded;
  ethos_class->plugin_unloaded = sample_manager_plugin_unloaded;

  g_type_class_add_private (object_class, sizeof (SampleManagerPrivate));
}

EthosManager *
sample_manager_dup_default (void)
{
  return g_object_new (SAMPLE_TYPE_MANAGER, NULL);
}
