#include "etpan-cfg-discover.h"

#include "etpan-folder-discover.h"
#include "etpan-cfg-account.h"
#include "etpan-cfg-vfolder.h"
#include "etpan-cfg-storage.h"
#include "etpan-errors.h"
#include "etpan-db-read.h"
#include "etpan-cfg-common.h"
#include <string.h>
#include <stdlib.h>

int etpan_discover_config_read(char * filename,
    struct etpan_app * app,
    struct etpan_account_config * account_config,
    struct etpan_storage_config * storage_config,
    struct etpan_discovery_manager ** pconfig)
{
  struct etpan_db * db;
  int r;
  struct etpan_discovery_manager * manager;
  int res;
  unsigned int i;
  
  manager = etpan_discovery_manager_new(app);
  if (manager == NULL) {
    res = ERROR_MEMORY;
    goto err;
  }
  
  r = etpan_read_config(filename, &db);
  if (r != NO_ERROR) {
    res = r;
    goto free_manager;
  }
  
  for(i = 0 ; i < carray_count(db->data) ; i ++) {
    chash * entry;
    char * type_str;
    char * storage_id;
    char * location;
    char * vpath;
    int type;
    struct mailstorage * storage;
    struct etpan_discovery_info * info;
    struct etpan_account_info * account;
    char * account_str;
    char * sent;
    char * draft;
    
    entry = carray_get(db->data, i);
    
    type_str = etpan_db_entry_get_value(entry, "type");
    if (type_str == NULL)
      continue;
    
    vpath = etpan_db_entry_get_value(entry, "name");
    if (vpath == NULL)
      continue;
    
    location = etpan_db_entry_get_value(entry, "location");
    if (location == NULL)
      continue;
    
    account_str = etpan_db_entry_get_value(entry, "account");
    sent = etpan_db_entry_get_value(entry, "sent");
    draft = etpan_db_entry_get_value(entry, "draft");
    
    type = etpan_cfg_storage_get_type(type_str);
    
    storage_id = NULL;
    storage = NULL;
    
    switch (type) {
    case STORAGE_TYPE_IMAP:
      storage_id = etpan_db_entry_get_value(entry, "storage");
      if (storage_id != NULL)
        storage = etpan_storage_get(storage_config, storage_id);
      break;
      
    case STORAGE_TYPE_MH:
    case STORAGE_TYPE_MBOX:
    case STORAGE_TYPE_MAILDIR:
      break;
      
    default:
      type = -1;
      break;
    }
    
    if (type == -1)
      continue;
    
    if ((type == STORAGE_TYPE_IMAP) && (storage == NULL))
      continue;
    
    if (location == NULL)
      location = "";
    
    location = strdup(location);
    if (location == NULL)
      continue;
    
    vpath = strdup(vpath);
    if (vpath == NULL) {
      free(location);
      continue;
    }
    
    r = etpan_cfg_strdup(&sent, sent);
    if (r != NO_ERROR) {
      free(vpath);
      free(location);
      continue;
    }
    
    etpan_cfg_strdup(&draft, draft);
    if (r != NO_ERROR) {
      free(sent);
      free(vpath);
      free(location);
      continue;
    }
    
    if (account_str != NULL)
      account = etpan_account_get(account_config, account_str);
    else
      account = NULL;
    
    info = etpan_discovery_info_new(type, storage, location, vpath,
        account, sent, draft);
    if (info == NULL) {
      free(draft);
      free(sent);
      free(vpath);
      free(location);
      continue;
    }
    
    r = etpan_discovery_manager_add(manager, info);
    if (r != NO_ERROR) {
      etpan_discovery_info_free(info);
      continue;
    }
  }
  
  * pconfig = manager;
  
  return NO_ERROR;
  
 free_manager:
  etpan_discovery_manager_free(manager);
 err:
  return res;
}

