#ifndef ETPAN_CFG_SENDER_TYPES_H

#define ETPAN_CFG_SENDER_TYPES_H

#include <sys/param.h>
#include <libetpan/libetpan.h>

enum {
  SENDER_TYPE_SMTP,
  SENDER_TYPE_COMMAND,
};

#define ETPAN_MAX_SENDER_NAME 512
#define ETPAN_MAX_HOSTNAME 4096
#define ETPAN_MAX_LOGIN 512
#define ETPAN_MAX_PASSWORD 512

struct etpan_sender_item {
  char name[ETPAN_MAX_SENDER_NAME];
  int type;
  char command[PATH_MAX];
  char host[ETPAN_MAX_HOSTNAME];
  int port;
  char login[ETPAN_MAX_LOGIN];
  char password[ETPAN_MAX_PASSWORD];
};

struct etpan_sender_config {
  char default_sender[ETPAN_MAX_SENDER_NAME];
  chash * sender_hash;
};

#endif
