/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-folder-params.h,v 1.6 2003/12/15 16:08:53 hoa Exp $
 */

#ifndef ETPAN_FOLDER_PARAMS_H

#define ETPAN_FOLDER_PARAMS_H

#include <libetpan/libetpan.h>
#include <inttypes.h>
#include "etpan-folder-params-types.h"

struct etpan_folder_params * etpan_folder_params_new(void);

void etpan_folder_params_free(struct etpan_folder_params * params);

int etpan_folder_params_add(struct etpan_folder_params * params,
    struct mailfolder * folder);

int etpan_folder_params_add_recursive(struct etpan_folder_params * params,
    struct mailfolder * root);

void etpan_folder_params_clear(struct etpan_folder_params * params);

int etpan_folder_get_stat(struct etpan_folder_params * folder_params,
    struct mailfolder * folder, uint32_t * num,
    uint32_t * recent, uint32_t * unseen);

void etpan_folder_set_stat(struct etpan_folder_params * folder_params,
    struct mailfolder * folder, int fetched, uint32_t num,
    uint32_t recent, uint32_t unseen);

void etpan_folder_set_visibility(struct etpan_folder_params * folder_params,
    struct mailfolder * folder, int visible);

int etpan_folder_is_visible(struct etpan_folder_params * folder_params,
    struct mailfolder * folder);

int etpan_folder_is_opened(struct etpan_folder_params * folder_params,
    struct mailfolder * folder);

void etpan_folder_set_opened(struct etpan_folder_params * folder_params,
    struct mailfolder * folder, int opened);

void etpan_folder_change_opened(struct etpan_folder_params * folder_params,
    struct mailfolder * folder);

void etpan_folder_set_folder_type(struct etpan_folder_params *
    folder_params,
    struct mailfolder * folder, int folder_type);

int etpan_folder_get_folder_type(struct etpan_folder_params *
    folder_params,
    struct mailfolder * folder);

#endif
