
#if defined (DEBUG) && !defined(EC_DEBUG_H)
#define EC_DEBUG_H

extern void debug_init(void);
extern void debug_msg(char *message, ...);

#define DEBUG_INIT() debug_init()

#ifdef MACOSX
   extern void DEBUG_MSG(char *message, ...);
#else
   #define DEBUG_MSG(x, args...) debug_msg(x, ## args)
#endif

#endif /* EC_DEBUG_H */

/* 
 * if DEBUG is not defined we expand the macros to null instructions...
 */

#ifndef DEBUG
   
   #define DEBUG_INIT()
   
   #ifdef MACOSX
      extern void DEBUG_MSG(char *message, ...);  /* workaround for Mac Os */
   #else   
      #define DEBUG_MSG(x, args...)
   #endif

#endif

/* EOF */

// vim:ts=3:expandtab

