/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_discover.h
 */

#ifndef _MD_DISCOVER_H_
#define _MD_DISCOVER_H_ 1

// Functions exported by md_discover.c

boolean md_check_for_expand_shrink_in_progress(md_volume_t *volume, md_member_t **member);
int md_restore_saved_sb(md_volume_t *volume);
void md_discover_volumes(list_anchor_t input_list, list_anchor_t output_list);
int md_register_name_space(void);
void md_discover_final_call(list_anchor_t input_list, list_anchor_t output_list, int *count);
void md_analyze_volume(md_volume_t *vol);
int md_analyze_active_region(md_volume_t *vol);


#endif

