/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __SNAP_CREATE_H__
#define __SNAP_CREATE_H__ 1

extern void make_parent_and_child(storage_object_t * parent,
				  storage_object_t * child);
extern void unmake_parent_and_child(storage_object_t * parent,
				    storage_object_t * child);
extern void add_snapshot_to_origin(snapshot_volume_t * snap_volume,
				   snapshot_volume_t * org_volume);
extern void remove_snapshot_from_origin(snapshot_volume_t * snap_volume);
extern char * skip_dev_path(char * volume_name);
extern snapshot_volume_t * allocate_snapshot(storage_object_t * snap_child,
					     snapshot_metadata_t * metadata);
extern void deallocate_snapshot(snapshot_volume_t * snap_volume);
extern snapshot_volume_t * allocate_origin(storage_object_t * org_child);
extern void deallocate_origin(snapshot_volume_t * org_volume);
extern evms_feature_header_t * allocate_feature_header(storage_object_t * snap_child,
						       char * snap_name);
extern snapshot_metadata_t * allocate_metadata(char * org_vol_name,
					       u_int64_t org_size,
					       u_int64_t snap_size,
					       u_int32_t chunk_size,
					       int writeable);
extern u_int64_t calculate_data_chunks(u_int64_t snap_child_size,
				       u_int32_t chunk_size);
extern int verify_origin(storage_object_t * org_child,
			 storage_object_t * snap_child);

#endif

