using System;
using System.Runtime.InteropServices;

namespace Evolution {
	public class CalUtil : GLibUtil {
		public static CalComponent[] GLibSListToCalCompArray (IntPtr slist, Cal ecal)
		{
			int i = 0;
			IntPtr iter = IntPtr.Zero;
			int len = 0;

			len = g_slist_length (slist);
			CalComponent[] compArray = new CalComponent [len];

			for (i = 0, iter=slist; iter != IntPtr.Zero; iter = gtksharp_slist_get_next (iter), i++) {
				CalComponent calComp = new CalComponent ();
				calComp.Uid = CalGlueComponentUtil.GetUid (gtksharp_slist_get_data (iter));
				calComp.RecurId = CalGlueComponentUtil.GetRecurId (gtksharp_slist_get_data (iter));
				calComp.Attendees = CalGlueComponentUtil.GetAttendees (gtksharp_slist_get_data (iter));
				calComp.Comments  = CalGlueComponentUtil.GetComments (gtksharp_slist_get_data (iter));
				calComp.Categories = CalGlueComponentUtil.GetCategories (gtksharp_slist_get_data (iter));
				calComp.Summaries = CalGlueComponentUtil.GetSummaries  (gtksharp_slist_get_data (iter));
				calComp.Descriptions = CalGlueComponentUtil.GetDescriptions (gtksharp_slist_get_data (iter));
				calComp.Location = CalGlueComponentUtil.GetLocation (gtksharp_slist_get_data (iter));
				calComp.Dtstart = CalGlueComponentUtil.GetDtstart (gtksharp_slist_get_data (iter)); 
				calComp.Dtend = CalGlueComponentUtil.GetDtend (gtksharp_slist_get_data (iter)); 
				calComp.LastModified = CalGlueComponentUtil.GetLastModified (gtksharp_slist_get_data (iter)); 
				calComp.Dtstamp = CalGlueComponentUtil.GetDtstamp (gtksharp_slist_get_data (iter)); 
				calComp.Created = CalGlueComponentUtil.GetCreated (gtksharp_slist_get_data (iter)); 
				calComp.ECal = ecal;
				calComp.RecurrenceRules = CalGlueComponentUtil.GetRecurrenceRules (gtksharp_slist_get_data (iter));
				calComp.ExceptionRules = CalGlueComponentUtil.GetExceptionRules (gtksharp_slist_get_data (iter));
				compArray[i] = calComp;

			}
			return compArray;
		}

		public static CalRecurrence[] GLibSListToCalRecurrenceArray (IntPtr slist)
		{			
			int i = 0;
			IntPtr iter = IntPtr.Zero;
			int len = 0;

			len = g_slist_length (slist);
			CalRecurrence[] rrules = new CalRecurrence [len];

			for (i = 0, iter=slist; iter != IntPtr.Zero; iter = gtksharp_slist_get_next (iter), i++) {
				CalRecurrence recur = new CalRecurrence ();
				recur.Frequency = CalGlueRecurrenceUtil.GetFrequency (gtksharp_slist_get_data (iter));
				recur.Count  = CalGlueRecurrenceUtil.GetCount (gtksharp_slist_get_data (iter));
				recur.Enddate = CalGlueRecurrenceUtil.GetEnddate (gtksharp_slist_get_data (iter));
				recur.WeekStartDay = CalGlueRecurrenceUtil.GetWeekStartDay (gtksharp_slist_get_data (iter));
				recur.Interval = CalGlueRecurrenceUtil.GetInterval (gtksharp_slist_get_data (iter));
				recur.BySecond = CalGlueRecurrenceUtil.GetBySecond (gtksharp_slist_get_data (iter));
				recur.ByMinute = CalGlueRecurrenceUtil.GetByMinute (gtksharp_slist_get_data (iter));
				recur.ByHour = CalGlueRecurrenceUtil.GetByHour (gtksharp_slist_get_data (iter));
				recur.ByDay = CalGlueRecurrenceUtil.GetByDay (gtksharp_slist_get_data (iter));
				recur.ByMonthDay = CalGlueRecurrenceUtil.GetByMonthDay (gtksharp_slist_get_data (iter));
				recur.ByYearDay = CalGlueRecurrenceUtil.GetByYearDay (gtksharp_slist_get_data (iter));
				recur.ByWeekNumber = CalGlueRecurrenceUtil.GetByWeekNumber (gtksharp_slist_get_data (iter));
				recur.ByMonth = CalGlueRecurrenceUtil.GetByMonth (gtksharp_slist_get_data (iter));
				recur.BySetPos = CalGlueRecurrenceUtil.GetBySetPos (gtksharp_slist_get_data (iter));

				rrules [i] = recur;
			}
			return rrules;
		}

		public static DateTime MinDate {
			get { return local_epoch; }
		}

		public static DateTime MaxDate {
			get { return local_epoch.AddSeconds (Int32.MaxValue); }
		}

		public static String GetQueryStringForTimeRange (DateTime start, DateTime end)
		{
			// Evo doesn't like dates before the epoch or after the max time, so
			// check for those and throw an exception.
			if (start < MinDate)
				throw new ArgumentOutOfRangeException ("start");

			if (end > MaxDate)
				throw new ArgumentOutOfRangeException ("end");

			string query;
			string strDtstart;
			string strDtend;
			strDtstart = String.Format ("{0:0000}{1:00}{2:00}T{3:00}{4:00}{5:00}Z",
							start.Year,
							start.Month,
							start.Day,
							start.Hour,
							start.Minute,
							start.Second);

			strDtend = String.Format ("{0:0000}{1:00}{2:00}T{3:00}{4:00}{5:00}Z",
							end.Year,
							end.Month,
							end.Day,
							end.Hour,
							end.Minute,
							end.Second);

			
			query = "(occur-in-time-range? (make-time \"" 
				+ strDtstart + "\")" 
				+ " (make-time \"" 
				+ strDtend + "\"))";
			
			return query;
		}


		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_from_objects_to_glue_components (IntPtr ical_objects);

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_from_ecal_comp_objects_to_glue_components (IntPtr ecal_objects);

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_free_glue_component_list (IntPtr glue_comp_list);

		public static CalComponent[] CalCompFromECal (IntPtr ecal_objects, Cal ecal)
		{
			CalComponent[] retArray;
			IntPtr raw_ret = e_cal_glue_from_ecal_comp_objects_to_glue_components (ecal_objects);
			retArray = GLibSListToCalCompArray (raw_ret, ecal);
			FreeGlueCompGLibSList (raw_ret);
			
			return retArray;
		}

		public static CalComponent[] CalCompFromICal (IntPtr ical_objects, Cal ecal)
		{
			CalComponent[] retArray;

			IntPtr raw_ret = e_cal_glue_from_objects_to_glue_components (ical_objects);
			retArray = GLibSListToCalCompArray (raw_ret, ecal);
			FreeGlueCompGLibSList (raw_ret);
			
			return retArray;
		}

		public static void FreeGlueCompGLibSList (IntPtr glue_comp_list)
		{
			e_cal_glue_free_glue_component_list (glue_comp_list);
		}
	}
}
