/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@susqu.edu                 *
*************************************************************/

/************************************************************
*
*  File:  lex.h
*
*  Contents: Definitions for lexical analyzer for reading
*        data files.
*/

/* Data type for yylval and parse semantics stack. */
typedef struct { int i;   /* standard integer yylval */
                 int qnum;
                 REAL r;
                 int etype;
                 int type;                 
                 struct sym *symptr; /* iteration variable names */
                 char lexeme[32]; /* for identifiers */
              } yystype;
#define YYSTYPE yystype
extern YYSTYPE yylval;  /* parser terminal value */

/* token values; single characters are themselves */
/* Tokens not part of expressions have negative values to act
    as end-of-input for yacc. These should not be eval() case numbers,
    which go in express.h.
*/

#define  NO_TOKEN        0
#define  WULFF_        -257
#define  PERIODS_     -256
#define  TORUS_        -252
#define  TORUS_FILLED_  -251
#define  SOAPFILM_    -249
#define  MOBILITY_    -248
#define  MOBILITY_TENSOR_  -247
#define  ENVECT_      -245
#define  CONVECT_     -244
#define  MERITFACTOR_    -243
#define  GRAV_CONST_     -242
#define  SPRING_CONSTANT_ -241
#define  TEMPERATURE_      -239
#define  FACES_          -237
#define  CONVEX_         -230
#define  NONNEGATIVE_      -229
#define  NONPOSITIVE_      -228
#define  PARAMETERS_    -227
#define  CONTENT_        -222
#define  BCOORD_         -219
#define  GLOBAL_         -217
#define  SURFACE_ENERGY_  -216
#define  SYMMETRIC_CONTENT_ -215
#define  SCALE_LIMIT_      -214
#define  CONSTRAINT_TOLERANCE_ -211
#define  ZOOM_VERTEX_      -210
#define  ZOOM_RADIUS_      -209
#define  QVECT_          -206
#define  SPACE_DIMENSION_ -205
#define  SURFACE_DIMENSION_ -204
#define  SIMPLEX_REP_      -203
#define  METRIC_         -202
#define  SYMMETRY_GROUP_  -201
#define  UNKNOWN         -199
#define  CONFORMAL_     -198
#define  SQUARE_CURVATURE_ -197
#define  PARAMETER_FILE_    -196
#define  TOTAL_TIME_     -191
#define  PHASEFILE_      -190
#define  KLEIN_METRIC_      -187
#define  INFO_QUANTITY_     -186
#define  GLOBAL_METHOD_     -185
#define  EFIXED_        -184
#define  VIEW_TRANSFORM_GENS_ -182
#define  GAUSS_CURVATURE_     -181
#define  INSULATING_KNOT_ENERGY_ -179
#define  CONDUCTING_KNOT_ENERGY_ -178
#define  METHOD_     -177
#define  NONWALL_        -176
#define  SCALAR_INTEGRAND_    -175
#define  VECTOR_INTEGRAND_    -174
#define  FORM_INTEGRAND_    -173
#define  PARAMETER_1_    -172
#define  OPTIMIZING_PARAMETER_ -171
#define  K_VEC_ORDER_ -170
#define  LAGRANGE_ORDER_ -169
#define  HESSIAN_DOUBLE_NORMAL_ -168
#define  INTERP_BDRY_PARAM_ -167
#define  HESSIAN_NORMAL_ -166
#define  HESSIAN_NORMAL_ONE_ -165
#define  HESSIAN_NORMAL_PERP_ -164
#define  HESSIAN_SPECIAL_NORMAL_ -163
#define  LOAD_LIBRARY_ -162
#define  IGNORE_CONSTRAINTS_ -161
#define  VERSION_ -160
#define  KEEP_MACROS_ -159
#define  LAGRANGE_MULTIPLIER_ -158
#define  SWAP_COLORS_ -157
#define  STRING_TYPE_ -156
#define  IGNORE_FIXED_ -155
#define  KEEP_ORIGINALS_ -154
#define  ELEMENT_MODULUS_ -153
#define  VOLUME_METHOD_NAME_ -152
#define  DIRICHLET_MODE_ -151
#define  SOBOLEV_MODE_ -150
#define  KRAYNIKPOPVERTEX_FLAG_ -148
#define  KRAYNIKPOPEDGE_FLAG_ -147
#define  VERSIONTOKEN_ -146
#define  HESSIAN_SPECIAL_NORMAL_VECTOR_ -145
#define  RGB_COLORS_FLAG_ -144
#define  CIRCULAR_ARC_DRAW_ -143
#define  VISIBILITY_TEST_ -142
#define  SPARSE_CONSTRAINTS_ -141
#define  BLAS_FLAG_ -140
#define  AUGMENTED_HESSIAN_ -139
#define  AREA_METHOD_NAME_ -138
#define  LENGTH_METHOD_NAME_ -137
#define  BREAK_AFTER_WARNING_ -136
