;;; ewb-index.el --- Functions to make and edit index of EWB.
;;
;; Copyright (C) 1999 ASCII Corporation
;;
;; This file is part of EWB.
;;
;;; Code:

(require 'ewb-tools)

(defvar ewb-index-initial-number 0
  "EWB Indexκǽֹ-1")

(defvar ewb-index-position-forward t
  "//inΰ֡tʤnilʤ")

(defvar ewb-kakasi-p t
  "kakasiȤʤtȤʤʤnil")

(defvar ewb-kakasi-option '("-JH" "-KH" "-kH" "-p")
  "EWBΤkakasiΥץ")

(defvar ewb-kakasi-command "kakasi"
  "EWBǻȤkakasiΥޥ̾")

(defvar ewb-kakasi-dictionary "xewbindex.dic"
  "EWBǻȤkakasiΥ桼̾")

(defvar ewb-index-string-style-completion-list
  '(("it" 1) ("bf" 2))
  "EWB indexstring styleθ")

(defvar ewb-index-history-1 nil
  "EWB index history 1.")

(defvar ewb-index-history-2 nil
  "EWB index history 2.")

(defvar ewb-index-history-3 nil
  "EWB index history 3.")

(defvar ewb-index-file-name "ForAll.index"
  "EWB index file name")

(defvar ewb-work-buffer-name " *ewb-temp-work*"
  "EWBѥХåե̾")

(defun ewb-index-entry-string-regulation (str)
  "ForAll.index˽񤭹२ȥʸ롣
ʸͿ줿ʸ֤"
  (let* ((kbuf (get-buffer-create ewb-work-buffer-name))
	 (result
	  (save-excursion
	    (save-restriction
	      (set-buffer kbuf)
	      (erase-buffer)
	      (insert str)
	      (beginning-of-buffer)
	      (replace-string "\\" "\\\\")
	      (beginning-of-buffer)
	      (replace-string ":" "\\:")
	      (buffer-substring (point-min) (point-max))))))
    (progn result)))

(defun ewb-index-sortkey-string-regulation (str)
  "ForAll.index˽񤭹ॽʸ롣
ʸͿ줿ʸ֤"
  (let* ((kbuf (get-buffer-create ewb-work-buffer-name))
	 (result
	  (save-excursion
	    (save-restriction
	      (set-buffer kbuf)
	      (erase-buffer)
	      (insert str)
	      (beginning-of-buffer)
	      (replace-string ":" "\\:")
	      (buffer-substring (point-min) (point-max))))))
    (progn result)))

(defun ewb-kakasi (str)
  "kakasi˰Ϥη̤֤"
  (let* ((kbuf (get-buffer-create ewb-work-buffer-name)))
    (save-excursion
      (set-buffer kbuf)
      (erase-buffer)
      (insert str)
      (let* ((options ewb-kakasi-option)
        (dic-file (list ewb-kakasi-dictionary))
        (options
          (if (file-exists-p ewb-kakasi-dictionary)
            (append options dic-file)
          options))
        )
      (apply 'call-process-region (point-min) (point-max)
        ewb-kakasi-command t
        (list kbuf nil) nil
        options))
      (buffer-substring (point-min) (point-max)))))

(defun ewb-write-kakasi-dictionary (kanji yomi)
  "kakasiѤΥ桼"
  (if (and (not (string= kanji ""))
	   (not (string= yomi "")))
      (let* ((ibuf (find-file-noselect ewb-kakasi-dictionary)))
	(save-excursion
	  (set-buffer ibuf)
	  (goto-char (point-max))
	  (insert (format "%s %s\n" yomi kanji))
	  (save-buffer)))))

(defun ewb-get-last-index-number-from-file ()
  "ForAll.indexǸιԤΥǥåֹ롣"
  (let* ((ibuf (find-file-noselect ewb-index-file-name)))
    (progn
      (save-excursion
	(set-buffer ibuf)
	(goto-char (point-max))
	(forward-line -1)
	(beginning-of-line)
	(if (re-search-forward ":\\([0-9]+\\):" nil t nil)
	    (string-to-number
	     (buffer-substring (match-beginning 1) (match-end 1)))
	  ewb-index-initial-number)))))

(defun ewb-index ()
  "ɬ׻minibuffer䤤碌ơ//in??񤭹ߡForAll.index롣
ĤƵưϡ٤ƤιܤˤĤ䤤碌Ԥ̵
ξϡȥϤǥե̤äϡΥȥ
Ϥǽλ롣ȥΥǥեȤϡΰꤵ줿ϰϤȤʤ롣"
  (interactive)
  (if (region-exists-p)
      (let* ((string (buffer-substring (region-beginning) (region-end)))
	     (string
	      (if (string-match "$" string)
		  (substring string 0 (match-end 0))
		string))
	     (mode (ewb-in-triger-on-str string))
	     (index-num
	      (ewb-index-function
	       mode
	       (ewb-remove-trigger string))))
	(progn
	  (if (= mode -1)
	      (progn
		(if ewb-index-position-forward
		    (goto-char (region-beginning))
		  (goto-char (region-end)))
		(ewb-insert-in-triger index-num))
	    (save-excursion
	      (goto-char (region-beginning))
	      (re-search-forward "//in\\([0-9]+\\)?[^0-9a-zA-Z]" nil t nil)
	      (search-backward "//in" nil t nil)
	      (ewb-remove-this-in-triger)
	      (ewb-insert-in-triger index-num)))))
    (if (ewb-on-in-triger-p)
	(let* ((index-num (ewb-get-in-triger-number))
	       (index-num
		(ewb-index-function index-num "")))
	  (progn
	    (if (not (= index-num -1))
		(progn
		  (ewb-remove-this-in-triger)
		  (ewb-insert-in-triger index-num)))
	    ))
      (progn
	(ding)
	(princ "ΰꤷƤ")))))

(defun ewb-in-triger-on-str (str)
  "ꤵ줿ʸ//inäƤ뤫
äƤСκֹ档
ֹ椬ؼƤʤС0
//inʤС-1֤"
  (let* ((tmps)
	 (r (string-match "//in\\([0-9]+\\)?[^0-9a-zA-Z]" str)))
    (progn
      (if r
	  (if (match-beginning 1)
	      (progn
		(setq tmps (substring str (match-beginning 1) (match-end 1)))
		(string-to-number tmps))
	    0)
	-1))))      

(defun ewb-remove-this-in-triger ()
  "ݥ󥿤Τ//in??롣"
  (save-excursion
    (while (= (following-char) 47)	; '/'
      (forward-char))
    (search-backward "//" nil t nil)
    (re-search-forward "//in\\([0-9]+\\)?" nil t nil)
    (replace-match "" nil nil nil)))

(defun ewb-get-in-triger-number ()
  "//in??ֹ롣//in??˥ݥ󥿤Ϥ롣"
  (save-excursion
    (while (= (following-char) 47)	; '/'
      (forward-char))
    (search-backward "//" nil t nil)
    (re-search-forward "//in\\([0-9]+\\)?" nil t nil)
    (string-to-number
     (buffer-substring (match-beginning 1) (match-end 1)))))

(defun ewb-on-in-triger-p ()
  "//in??ξ˥ݥȤ뤫"
  (let ((cur-pt (point)))
    (progn
      (save-excursion
	(while (= (following-char) 47)	; '/'
	  (forward-char))
	(if (search-backward "//" nil t nil)
	    (if (re-search-forward "//in\\([0-9]+\\)?" nil t nil)
		(progn
		  (if (and (<= (match-beginning 0) cur-pt)
			   (> (match-end 0) cur-pt))
		      t
		    nil))
	      nil)
	  nil)))))

(defun ewb-insert-in-triger (index-num)
  "ߤΥݥȤindex-num//in??񤭹ࡣ"
  (insert (format "//in%d" index-num))
  (if (and (>= (following-char) 48)	; if digits
	   (<= (following-char) 59))
      (insert " ")))

(defun ewb-index-function (index str)
  "ǽΡindexϺstrϥȥʸ
index = 0        : ֹĤ餹٤䤤碌Ԥ
index = -1       : ֹĤϼưǹԤֹĤ䤤碌ϹԤʤ
index = 嵭ʳ : ForAll.index õˤդФιܤԽ
                   strʤ顢ForAll.indexˤ륨ȥ꤬ǥեȤˤʤ롣
str ꤵƤС򥨥ȥ˻Ȥ
ForAll.indexκǸκֹ⾮ֹɲä硢
ǸForAll.indexֹǥȤ롣
ͤϡֹ档
ʸνϸƤӽФ¦ǡewb-index-function äƤԤ"
;
  (let* ((c)
	 (append-p
	  (or
	   (<= index 0)
	   (not (ewb-is-index-on-forall-p index))))
	 (max-index-num
	  (ewb-get-last-index-number-from-file))
	 (index-num
	  (if (> index 0)
	      index
	    (+ max-index-num 1)))
	 (index-num
	  (if (ewb-is-index-on-forall-p index-num)
	      (progn
		(setq c (read-string
			 (concat
			  (format "No.%d: \"" index-num)
			  (ewb-entry-on-forall index-num 1)
			  "\" ԽޤǤ(y/n) : "
			  )))
		(if (or
		     (string= c "y")
		     (string= c "yes")
		     (string= c ""))
		    index-num
		  -1))
	      index-num))
	 (index-num
	  (if (= index 0)
	      (progn
		(while (ewb-is-index-on-forall-p
			(setq c
			      (string-to-number
			       (read-string "Index Number: "
					    (number-to-string index-num)))))
		  (read-string
		   (format
		    (concat
		     "No.%dϴ˻ȤƤޤ"
		     "Enter򲡤ƻꤷʤƤ: ")
		    c)))
		c)
	    index-num))
	 (sort-p nil)
	 (sort-p
	  (if append-p
	      (if (< index-num max-index-num)
		  t))))
    (progn
      (if (not (= index-num -1))
	  (make-index index-num str append-p sort-p)
	index-num))))

(defun make-index (index-num str append-p sort-p)
  (let* ((entry str)
	 (entry1
	  (read-from-minibuffer "1: "
				(if append-p
				    entry
				  (if (string= entry "")
				      (ewb-entry-on-forall index-num 1)
				    entry))
				nil nil
				'ewb-index-history-1))
	 (sortkey1
	  (read-from-minibuffer "ɤ1: "
				(if ewb-kakasi-p
				    (ewb-kakasi entry1)
				  entry1)
				nil nil 'ewb-index-history-1))
	 (entry2
	  (read-from-minibuffer "2: "
				(if append-p
				    (if (string= entry entry1)
					""
				      entry)
				  (ewb-entry-on-forall index-num 2))
				nil nil
				'ewb-index-history-2))
	 (sortkey2
	  (if (string= entry2 "") ""
	    (read-from-minibuffer "ɤ2: "
				  (if ewb-kakasi-p
				      (ewb-kakasi entry2)
				    entry2)
				  nil nil 'ewb-index-history-2)))
	 (entry3
	  (if (string= entry2 "") ""
	    (read-from-minibuffer "3: "
				  (if append-p
				      (if (string= entry entry1)
					  ""
					entry)
				    (ewb-entry-on-forall index-num 3))
				  nil nil
				  'ewb-index-history-3)))
	 (sortkey3
	  (if (string= entry3 "") ""
	   (read-from-minibuffer "ɤ3: "
				 (if ewb-kakasi-p
				     (ewb-kakasi entry3)
				   entry3)
				 nil nil 'ewb-index-history-3)))
	 (style
	  (completing-read "ڡֹʸ(ʤ/it/bf): "
			   ewb-index-string-style-completion-list nil t
			   (if append-p
			       ""
			     (ewb-style-on-forall index-num))))
	 )
    (progn
      (if (not (string= entry1 ""))
	  (progn
	    (if append-p
		(ewb-append-forall
		 (number-to-string index-num)
		 entry1 sortkey1
		 entry2 sortkey2
		 entry3 sortkey3
		 style)
	      (ewb-edit-forall
	       (number-to-string index-num)
	       entry1 sortkey1
	       entry2 sortkey2
	       entry3 sortkey3
	       style))
	    (ewb-write-kakasi-dictionary entry1 sortkey1)))
      (if sort-p
	  (ewb-sort-forall-buffer-by-index-num))
      index-num)))

(defun ewb-append-forall (index entry1 sortkey1 entry2 sortkey2 entry3 sortkey3 style)
  "ForAll.index˹ܤɲä롣Ϥ٤ʸ"
  (let* (
	 (obuf (current-buffer))
	 (ibuf (find-file-noselect ewb-index-file-name))
	 (cline (count-lines (point-min) (point)))
	 (ofilename (substring buffer-file-name
			       (+ 1 (string-match "/[^/]+$" buffer-file-name))))
	 )
    (progn
      (save-excursion
	(set-buffer ibuf)
	(goto-char (point-max))
	(insert
	 (format "../%s:%s:%d:%s:%s:%s:%s:%s:%s:%s:\n"
		 ofilename index cline
		 (ewb-index-entry-string-regulation entry1)
		 (ewb-index-sortkey-string-regulation sortkey1)
		 (if (string= entry2 "") ""
		   (ewb-index-entry-string-regulation entry2))
		 (if (string= sortkey2 "") ""
		   (ewb-index-sortkey-string-regulation sortkey2))
		 (if (string= entry2 "") ""
		   (ewb-index-entry-string-regulation entry3))
		 (if (string= sortkey3 "") ""
		   (ewb-index-sortkey-string-regulation sortkey3))
		 style))
	(save-buffer)
	(set-buffer obuf)))))

(defun ewb-edit-forall (index entry1 sortkey1 entry2 sortkey2 entry3 sortkey3 style)
  "ForAll.indexindexܤѹ롣Ϥ٤ʸ"
  (let* (
	 (obuf (current-buffer))
	 (ibuf (find-file-noselect ewb-index-file-name))
	 (cline (count-lines (point-min) (point)))
	 (ofilename (file-name-nondirectory (buffer-file-name)))
	 )
    (progn
      (save-excursion
	(set-buffer ibuf)
	(goto-char (point-min))
	(re-search-forward (concat "^\.\./" ofilename ":" index ":" ) nil t nil)
	(beginning-of-line)
	(kill-line)
	(insert
	 (format "../%s:%s:%d:%s:%s:%s:%s:%s:%s:%s:"
		 ofilename index cline
		 (ewb-index-entry-string-regulation entry1)
		 (ewb-index-sortkey-string-regulation sortkey1)
		 (if (string= entry2 "") ""
		   (ewb-index-entry-string-regulation entry2))
		 (if (string= sortkey2 "") ""
		   (ewb-index-sortkey-string-regulation sortkey2))
		 (if (string= entry2 "") ""
		   (ewb-index-entry-string-regulation entry3))
		 (if (string= sortkey3 "") ""
		   (ewb-index-sortkey-string-regulation sortkey3))
		 style))
	(save-buffer)
	(set-buffer obuf)))))

(defun ewb-index-jump-to-forall ()
  "//in??˳ForAll.indexιԤ֡
tԤnil֤"
  (interactive)
  (let* ((fname (file-name-nondirectory (buffer-file-name)))
	 (inum-s
	  (save-excursion
	    (if (not (= (following-char) 47))
		(search-backward "/"))
	    (while (= (following-char) 47)
	      (backward-char))
	    (if (re-search-forward "//in\\([0-9]+\\)" nil t nil)
		(buffer-substring (match-beginning 1) (match-end 1))))))
    (progn
     (if (one-window-p)
	 (split-window))
     (other-window 1)
     (find-file ewb-index-file-name)
     (goto-char (point-min))
     (if (re-search-forward (concat "^\.\./" fname ":" inum-s ":") nil t nil)
	 (progn
	   (beginning-of-line)
	   t)
       (progn
	 (ding)
	 (princ (format "No.%sĤޤ" inum-s))
	 nil)))))

(defun ewb-index-jump-from-forall ()
  "ForAll.indexθ߹Ԥ˳ʸ//in??ΰ֤֡
tԤnil֤"
  (interactive)
  (let* ((fname
	  (save-excursion
	    (beginning-of-line)
	    (if (re-search-forward "^\.\./\\([^:]+\\):" nil t nil)
		(buffer-substring (match-beginning 1) (match-end 1)))))
	 (inum-s
	  (save-excursion
	    (beginning-of-line)
	    (if (re-search-forward "^[^:]+:\\([0-9]+\\):" nil t nil)
		(buffer-substring (match-beginning 1) (match-end 1)))))
	 (lnum-s
	  (save-excursion
	    (beginning-of-line)
	    (if (re-search-forward "^[^:]+:[0-9]+:\\([0-9]+\\):" nil t nil)
		(buffer-substring (match-beginning 1) (match-end 1))))))
    (progn
     (if (one-window-p)
	 (split-window))
     (other-window 1)
     (find-file fname)
;     (goto-line (string-to-number lnum-s))
     (goto-char (point-min))
     (if (re-search-forward (concat "//in" inum-s "[^0-9]"))
	 (progn
	   (backward-char)
	   t)
       (progn
	 (ding)
	 (princ (format "No.%sĤޤ" inum-s))
	 nil)))))

(defun ewb-index-jump-forall ()
  "ե̾ForAll.indexʤewb-index-jump-from-forall
Ǥʤewb-index-jump-to-forallƤ֡"
  (interactive)
  (if (string= (file-name-nondirectory (buffer-file-name)) ewb-index-file-name)
      (ewb-index-jump-from-forall)
    (ewb-index-jump-to-forall)))

(defun ewb-remove-index ()
  "ݥ󥿤Τ//in??ȤκֹForAll.indexιܤ롣"
  (interactive)
  (let* ((c)
	 (obuf (current-buffer))
	 (fname (file-name-nondirectory (buffer-file-name)))
	 (ibuf (find-file-noselect ewb-index-file-name)))
    (if (ewb-on-in-triger-p)
	(if (= (setq c (ewb-get-in-triger-number)) 0)
	    (progn
	      (ding)
	      (princ "//inȥꥬ˺ֹ椬ꤵƤޤ"))
	  (if (ewb-is-index-on-forall-p c)
	      (if (string=
		   "yes"
		   (read-string
		    (concat
		     "No."
		     (number-to-string c)
		     ": \""
		     (ewb-entry-on-forall c 1)
		     "\" ޤǤ(yes/no) : ")))
		  (save-excursion
		    (ewb-remove-this-in-triger)
		    (set-buffer ibuf)
		    (goto-char (point-min))
		    (re-search-forward
		     (concat "^../" fname ":" (number-to-string c) ":")
		     nil t nil)
		    (beginning-of-line)
		    (kill-line)
		    (kill-line)
		    (save-buffer)
		    (set-buffer obuf)))
	    (progn
	      (ding)
	      (princ (format "No.%dιܤĤޤ" c)))))
      (progn
	(ding)
	(princ "//inȥꥬ˥ݥ󥿤ޤ")))))

(defun ewb-remove-index-forall ()
  "ݥ󥿤ΤForAll.indexιܤȤκֹ//in??롣"
  (interactive)
  (let* ((inum-s)(fname)(entry)(tbuf)
	 (line (get-one-line-from-buffer))
	 (obuf (current-buffer)))
    (if (not
	 (string-match
	  "^../\\([^:]+\\):\\([0-9]+\\):[0-9]+:\\(\\(\\(\\\\:\\)\\|[^:]\\)+\\):" line))
	(progn
	  (ding)
	  (princ "ܤĤޤ"))
      (if (string= ""
		   (setq inum-s (substring line (match-beginning 2) (match-end 2))))
	  (progn
	    (ding)
	    (princ "ֹ椬Ĥޤ"))
	(if (string= ""
		     (setq fname (substring line (match-beginning 1) (match-end 1))))
	    (progn
	      (ding)
	      (princ "ե̾դޤ"))
	  (progn
	    (setq entry (substring line (match-beginning 3) (match-end 3)))
	    (if (string=
		 "yes"
		 (read-string
		  (concat
		   "No." inum-s ": \"" entry
		   "\" ޤǤ(yes/no) : ")))
		(save-excursion
		  (setq tbuf (find-file-noselect fname))
		  (set-buffer tbuf)
		  (goto-char (point-min))
		  (if (re-search-forward (concat "//in" inum-s "[^0-9]"))
		      (progn
			(backward-char)
			(ewb-remove-this-in-triger)
			(set-buffer obuf)
			(beginning-of-line)
			(kill-line)
			(kill-line)
			(save-buffer))
		    (progn
		      (set-buffer obuf)
		      (ding)
		      (princ (format "No.%sĤޤ" inum-s))))))))))))

(defun ewb-is-index-on-forall ()
  "//in??ForAll.indexˤ뤫ɤå롣
//in??ֹǤʤ-1
դ0դʤ//in??ֹ֤"
  (let* ((obuf (current-buffer))
	 (fname (file-name-nondirectory (buffer-file-name)))
	 (ibuf (find-file-noselect ewb-index-file-name))
	 (inum-s
	    (if (re-search-forward "//in\\([0-9]+\\)" nil t nil)
		(buffer-substring (match-beginning 1) (match-end 1))
	      "")))
    (progn
      (if (string= inum-s "")
	    -1
	(progn
	  (set-buffer ibuf)
	  (goto-char (point-min))
	  (if (re-search-forward (concat "^\.\./" fname ":" inum-s ":") nil t nil)
	      (progn
		(set-buffer obuf)
		0)
	    (progn
	      (set-buffer obuf)
	      (string-to-int inum-s))))))))

(defun ewb-is-index-on-forall-p (idx)
  "ꤵ줿ֹιܤForAll.indexˤ뤫ɤå롣
ֹ椬0Ǥ뤫ֹ椬ForAll.index˸դʤСnil֤
ֹ椬դСt֤"
  (let* ((obuf (current-buffer))
	 (fname (file-name-nondirectory (buffer-file-name)))
	 (ibuf (find-file-noselect ewb-index-file-name)))
    (progn
      (if (<= idx 0)
	  nil
	(progn
	  (set-buffer ibuf)
	  (goto-char (point-min))
	  (if (re-search-forward (concat "^\.\./" fname ":" (number-to-string idx) ":") nil t nil)
	      (progn
		(set-buffer obuf)
		t)
	    (progn
	      (set-buffer obuf)
	      nil)))))))

(defun ewb-entry-on-forall (idx n)
  "ꤵ줿ֹ(idx)ιܤForAll.indexˤСιܤnܤΥȥ֤"
  (let* ((line)(result)
	 (obuf (current-buffer))
	 (fname (file-name-nondirectory (buffer-file-name)))
	 (ibuf (find-file-noselect ewb-index-file-name)))
    (progn
      (if (<= idx 0)
	  nil
	(if (or (> n 3)
		(< n 1))
	    nil
	  (progn
	    (set-buffer ibuf)
	    (goto-char (point-min))
	    (if (re-search-forward (concat "^\.\./" fname ":" (number-to-string idx) ":") nil t nil)
		(progn
		  (setq line (get-one-line-from-buffer))
		  (string-match
		   (concat
		    "[^:]+:[0-9]+:[0-9]+:"
		    "\\(\\(\\(\\\\:\\)\\|[^:]\\)*\\):"
		    "\\(\\(\\\\:\\)\\|[^:]\\)*:"
		    "\\(\\(\\(\\\\:\\)\\|[^:]\\)*\\):"
		    "\\(\\(\\\\:\\)\\|[^:]\\)*:"
		    "\\(\\(\\(\\\\:\\)\\|[^:]\\)*\\):"
		    "\\(\\(\\\\:\\)\\|[^:]\\)*:"
		    "[a-zA-Z]*:$"
		    )
		   line)
		  (setq result (ewb-index-entry-string-unregulation
				(match-string
				 (+ (* (- n 1) 5) 1) ; \\(..\\) 
				 line)))
		  (set-buffer obuf)
		  result)
	      (progn
		(set-buffer obuf)
		nil))))))))

(defun ewb-sortkey-on-forall (idx n)
  "ꤵ줿ֹ(idx)ιܤForAll.indexˤСιܤnܤɤߤ֤"
  (let* ((line)(result)
	 (obuf (current-buffer))
	 (fname (file-name-nondirectory (buffer-file-name)))
	 (ibuf (find-file-noselect ewb-index-file-name)))
    (progn
      (if (<= idx 0)
	  nil
	(if (or (> n 3)
		(< n 1))
	    nil
	  (progn
	    (set-buffer ibuf)
	    (goto-char (point-min))
	    (if (re-search-forward (concat "^\.\./" fname ":" (number-to-string idx) ":") nil t nil)
		(progn
		  (setq line (get-one-line-from-buffer))
		  (string-match
		   (concat
		    "[^:]+:[0-9]+:[0-9]+:"
		    "\\(\\(\\\\:\\)\\|[^:]\\)*:"
		    "\\(\\(\\(\\\\:\\)\\|[^:]\\)*\\):"
		    "\\(\\(\\\\:\\)\\|[^:]\\)*:"
		    "\\(\\(\\(\\\\:\\)\\|[^:]\\)*\\):"
		    "\\(\\(\\\\:\\)\\|[^:]\\)*:"
		    "\\(\\(\\(\\\\:\\)\\|[^:]\\)*\\):"
		    "[a-zA-Z]*:$"
		    )
		   line)
		  (setq result (ewb-index-entry-string-unregulation
				(match-string
				 (+ (* (- n 1) 5) 3) ; \\(..\\) 
				 line)))
		  (set-buffer obuf)
		  result)
	      (progn
		(set-buffer obuf)
		nil))))))))

(defun ewb-style-on-forall (idx)
  "ꤵ줿ֹ(idx)ιܤForAll.indexˤСιܤstyle֤"
  (let* ((line)(result)
	 (obuf (current-buffer))
	 (fname (file-name-nondirectory (buffer-file-name)))
	 (ibuf (find-file-noselect ewb-index-file-name)))
    (progn
      (if (<= idx 0)
	  nil
	(progn
	  (set-buffer ibuf)
	  (goto-char (point-min))
	  (if (re-search-forward (concat "^\.\./" fname ":" (number-to-string idx) ":") nil t nil)
	      (progn
		(setq line (get-one-line-from-buffer))
		(string-match ":\\([a-zA-Z]*\\):$" line)
		(setq result (match-string 1 line))
		(set-buffer obuf)
		result)
	    (progn
	      (set-buffer obuf)
	      nil)))))))

(defun ewb-sort-forall-buffer-by-index-num ()
  "ForAll.indexΤֹǥȤ롣"
  (interactive)
  (let* ((obuf (current-buffer))
	 (tmpfname (make-temp-name "/tmp/ForAll.index"))
	 (ibuf (find-file-noselect ewb-index-file-name)))
    (progn
      (set-buffer ibuf)
      (call-process			; cp backup
       "/bin/sh" nil nil nil "-c"
       "cp ForAll.index ForAll.index.bak")
      (call-process-region		; sort
       (point-min) (point-max)
       shell-file-name
       t				; delete region
       nil				; send output to temp file
       nil				; no redisplay during output
       "-c"
       (concat "sort -t \':\' -n -k 2 > " tmpfname))
      (insert-file tmpfname)
      (delete-file tmpfname)
      (save-buffer)
      (set-buffer obuf)
      )))

(defun ewb-convert-all-idx ()
  "//idxǻꤵ줿ʬ򤹤٤//inѴ롣"
  (interactive)
  (let ((first-point)(last-point)(p)(idx-num))
    (progn
      (goto-char (point-min))
      (while (search-forward "//idx" nil t nil)
	(progn
	  (setq first-point (match-beginning 0))
	  (set-mark first-point)
	  (if (not (= (following-char) 123))
	      (progn
		(exchange-point-and-mark)
		(setq idx-num (ewb-index-function -1 ""))
		(goto-char first-point)
		(delete-char 5)
		(ewb-insert-in-triger idx-num)
		)
	    (progn
	      (re-search-forward "$" nil t nil)
	      (setq last-point (- (point) 1))
	      (save-restriction
		(narrow-to-region first-point last-point)
		(goto-char first-point)
		(ewb-next-close)
		(setq last-point (point))
		)
	      (goto-char (+ last-point 1))
	      (exchange-point-and-mark)
	      (setq idx-num
		    (ewb-index-function
		     -1
		     (ewb-remove-trigger
		      (buffer-substring (region-beginning) (region-end)))))
	      ;; ΰθν
	      (goto-char (- last-point 2))
	      (if (= (following-char) 47) ; '/'
		  (progn
		    (forward-char)
		    (if (= (following-char) 47) ; '/'
			(progn
			  (forward-char)
			  (if (= (following-char) 125) ; '}'
			      (progn
				(forward-char)
				(delete-backward-char 3)))))))
	      (if (not ewb-index-position-forward)
		  (ewb-insert-in-triger idx-num))
	      ;; ΰν
	      (goto-char first-point)
	      (delete-char 6)
	      (if ewb-index-position-forward
		  (ewb-insert-in-triger idx-num))
	      )))
	(forward-char)
	))))


(provide 'ewb-index)

;;; Local Variables:
;;; mode: outline-minor
;;; End:

;;; ewb-index.el ends here.
