;;; ewb-tools.el --- Miscellaneous functions for ewb-mode.
;;
;; Copyright (C) 1999 ASCII Corporation
;;
;; This file is part of EWB.
;;
;;; Code:

(defun get-one-line-from-buffer ()
  "Хåե1Լʸ֤"
  (save-excursion
    (let ((line-top
	   (progn
	     (beginning-of-line)
	     (point))))
      (re-search-forward "$" nil t nil)
      (buffer-substring line-top (point)))))

(defun ewb-next-close ()
  "ߥݥȤΤ볫ȥꥬбĤȥꥬդ롣
ƤӽФˤϡݥȤϥȥꥬκǽˤʤФʤʤ
֤ͤϤʤбĤȥꥬ֡⤷ϸդʤ
ХåեκǸ塢˰ưƽ롣
ȥꥬʸϹθĤδطȽǤƤ롣"
  (let* ((c (ewb-is-next-open))
	 (r c))
    (progn
      (while (not (= c 0))
	(setq r (ewb-is-next-open))
	(if (= r 0)
	    (progn
	      (goto-char (point-max))
	      (setq c 0))
	  (setq c (+ c r)))
	)
      )))

(defun ewb-is-next-open ()
  "ȥꥬʤ1ȥꥬĤʤ-1ȥꥬդʤ0֤"
  (if (re-search-forward "//\\([a-zA-Z0-9]+\\)?[{}]" nil t nil)
      (progn
	(backward-char)
	(if (= (following-char) 123)
	    1
	  -1))
    0))

(defun ewb-remove-trigger (str)
  "˻ꤵ줿ʸ󤫤EWBΥȥꥬ򤹤٤Ƽ"
  (if (stringp str)
      (progn
	(while (string-match "//in\\([0-9]+\\)?\\([^0-9]+\\)" str)
	  (setq str (replace-match "\\2" t nil str)))
	(while (string-match "//\\([a-zA-Z0-9]+\\)?[{}|]?" str)
	  (setq str (replace-match "" t nil str)))
	(while (string-match "@@\\([a-zA-Z0-9]+(\\(-?[0-9\.]+[a-zA-Z]+\\)?)\\)\\|\\(@@\\)" str)
	  (setq str (replace-match "" t nil str)))
	)
    "")
  str)

(defun ewb-index-entry-string-unregulation (str)
  "˻ꤵ줿ʸ\:򤹤٤:ˤ롣"
  (if (stringp str)
      (while (string-match "\\\\:" str)
	(setq str (replace-match ":" t nil str)))
    "")
  str)


(provide 'ewb-tools)

;;; Local Variables:
;;; mode: outline-minor
;;; End:

;;; ewb-tools.el ends here.
