#!/usr/bin/perl

######################################################
# NAI VirusScan DAT file auto updater
# May 2001, Bas Rijniersce, bas@brijn.nu

$version = "0.02";

# Set silent to 1 to suppress normal output (useful for cron use)
$silent = 0;

# Location of the required files
$lynx = "/usr/bin/lynx";
$daturl = "ftp://ftpeur.nai.com/pub/datfiles/english";
$datdir = "/usr/local/uvscan";
$wget = "/usr/bin/wget";  
$tar = "/bin/tar";
$ls = "/bin/ls";
$rm = "/bin/rm";

# Initialize variables
$cur_vers = 0;
$rem_vers = 0;
$result = "";

# Tell who we are
print "Naiupdt $version <bas\@brijn.nu>\n\n" if (!$silent);

# Do some checking on needed binaries
# Assuming that ls and rm are in their default locations (valid on != Linux?)
print "Checking for Lynx ..\t\t" if (!$silent);
if (!(-x $lynx)) {
        print "Lynx ($lynx) not found, can't continue\n";
        exit(1);
} else { print "OK\n" if (!$silent); }

print "Checking for wget ..\t\t" if (!$silent);
if (!(-x $wget)) {
        print "Wget ($wget) not found, can't continue\n";
        exit(1);
} else { print "OK\n" if (!$silent); }

print "Checking DAT directory ..\t" if (!$silent);
if (!(-w $datdir)) {
        print "DAT dir ($datdir) not found or writable, can't continue\n";
        exit(1);
} else { print "OK\n" if (!$silent); }

print "Checking for tar ..\t\t" if (!$silent);
if (!(-x $tar)) {
        print "Tar ($tar) not found, can't continue\n";
        exit(1);
} else { print "OK\n" if (!$silent); }

# Get local DAT file version. Use file_id.diz to determine last installed version
print "Checking local DAT file ..\t" if (!$silent);
open (ID, "$datdir/file_id.diz");
while (<ID>) {
        if ( $_ =~ s/\((.+)\).+/$1/g ) {
                $cur_vers = $_;
                chop $cur_vers;
                print "Found\n" if (!$silent);
                last;
        }
}
close(ID);
if ($cur_vers == 0) { print "None found\n" if (!$silent); }


# Get remote DAT file version
open (LYNX, "LYNX=vt100 $lynx -source $daturl 2>&1 |"); # Lynx needs term type
while (<LYNX>) {
        if ( $_ =~ /Alert/g ) {
                print "Unable to connect to $daturl .. maybe more luck on next run\n";
                exit(1);
        }
        elsif ( $_ =~ s/.+dat-([0-9]+).tar"/$1/g ) {
                $rem_vers = $_;
                chop $rem_vers;
        }
}
close(LYNX);

# Check if the remote version is newer then the local version
print ("Current version of DAT file ..\t$cur_vers\n") if (!$silent);
print ("Updated version of DAT file ..\t$rem_vers\n") if (!$silent);

if ($rem_vers > $cur_vers) {
        print "Get newer DAT file ..\n" if (!$silent);
        print("Executing .. $wget -T 300 -q -nc $daturl\/dat-$rem_vers.tar\n") if (!$silent);
        $res = system("cd $datdir; $wget -T 300 -q -nc $daturl\/dat-$rem_vers.tar > /dev/null 2>&1");
        if ($res != 0) {
                # Download failed somehow, notify and remove downloaded file
                print("Download of DAT file failed .. maybe more luck on next run\n");
                print("Removing partially downloaded DAT file ..\n");
                $res = system("cd $datdir; $rm -f dat-$rem_vers.tar > /dev/null 2>&1");
                if ($res != 0) {
                        print("Remove of DAT file failed .. Remove manually\n");
                        exit(1);
                }
                else { exit(1); }
        }
        else {
                # File received OK
                print("Download of DAT file finished ..\n") if (!$silent);

                print("Starting unpacking of DAT file ..\n") if (!$silent);
                print("Executing .. $tar xvf dat-$rem_vers.tar\n") if (!$silent);
                $res = system("cd $datdir; $tar xvf dat-$rem_vers.tar > /dev/null 2>&1");
                if ($res != 0) {
                        print("Unpacking of DAT file failed ..\n");
                        print("Removing DAT file ..\n");
                        $res = system("cd $datdir; $rm -f dat-$rem_vers.tar > /dev/null 2>&1");
                        if ($res != 0) {
                                print("Remove of DAT file failed .. Remove manually\n");
                                exit(1);
                        }
                        else { exit(1); }
                }
                else {
                        print("Unpacking of DAT file successful .. Removing DAT file\n") if (!$silent);
                        $res = system("cd $datdir; rm -f dat-$rem_vers.tar > /dev/null 2>&1");
                        if ($res != 0) {
                                print("Remove of DAT file failed .. Remove manually\n");
                                exit(2);
                        }
                }
        }
}
else {
        print ("Your DAT file is up to date ..\n");
        exit(0);
} 
