/****************************************************************\
*                                                                *
*  The exonerate client                                          *
*                                                                *
*  Guy St.C. Slater..   mailto:guy@ebi.ac.uk                     *
*  Copyright (C) 2000-2006.  All Rights Reserved.                *
*                                                                *
*  This source code is distributed under the terms of the        *
*  GNU Lesser General Public License. See the file COPYING       *
*  or http://www.fsf.org/copyleft/lesser.html for details        *
*                                                                *
*  If you use this code, please keep this notice intact.         *
*                                                                *
\****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#ifdef HAVE_READLINE
#include <readline/readline.h>
#include <readline/history.h>
#endif /* HAVE_READLINE */

#include "argument.h"
#include "socket.h"

static gchar *read_next_line(gchar *prompt){
    gchar buffer[1024];
    register gchar *msg = NULL;
    g_print("%s", prompt);
    if(!fgets(buffer, 1024, stdin))
          g_error("Didn't read anything");
    if(buffer[0] != '\n')
        msg = g_strdup(buffer);
    return msg;
    }

static void run_client(gchar *host, gint port){
    register SocketClient *sc = SocketClient_create(host, port);
    register gchar *msg, *reply;
    while(TRUE){
#ifdef HAVE_READLINE
        msg = readline("> ");
#else /* HAVE_READLINE */
        msg = read_next_line("> ");
#endif /* HAVE_READLINE */
        if(!msg)
            continue;
        if(!strncmp(msg, "close", 5))
            break;
        reply = SocketClient_send(sc, msg);
        if(reply){
            g_print("%s", reply);
            g_free(reply);
            }
        g_free(msg);
        }
    SocketClient_destroy(sc);
    return;
    }

int Argument_main(Argument *arg){
    gint port;
    gchar *host;
    register ArgumentSet *as = ArgumentSet_create("Exonerate client options");
    ArgumentSet_add_option(as, '\0', "host", "host",
            "Name of host running exonerate server", "localhost",
            Argument_parse_string, &host);
    ArgumentSet_add_option(as, '\0', "port", "port",
            "Port on which exonerate server is running", "12345",
            Argument_parse_int, &port);
    Argument_absorb_ArgumentSet(arg, as);
    Argument_process(arg, "exonerate-client", "Exonerate Client.\n",
            "Guy St.C. Slater.  guy@ebi.ac.uk June 2006\n");
    g_message("host [%s] port [%d]", host, port);
    run_client(host, port);
    g_message("client exiting");
    return 0;
    }

