/****************************************************************\
*                                                                *
*  fasta2esd - generate an exonerate sequence database file      *
*                                                                *
*  Guy St.C. Slater..   mailto:guy@ebi.ac.uk                     *
*  Copyright (C) 2000-2006.  All Rights Reserved.                *
*                                                                *
*  This source code is distributed under the terms of the        *
*  GNU Lesser General Public License. See the file COPYING       *
*  or http://www.fsf.org/copyleft/lesser.html for details        *
*                                                                *
*  If you use this code, please keep this notice intact.         *
*                                                                *
\****************************************************************/

#include "argument.h"
#include "dataset.h"
#include "alphabet.h"
#include "fastadb.h"

int Argument_main(Argument *arg){
    register ArgumentSet *as
           = ArgumentSet_create("Sequence Input Options");
    GPtrArray *input_path_list;
    gchar *output_path;
    gboolean is_dna, softmask_input;
    register Dataset *dataset;
    ArgumentSet_add_option(as, 'f', "fasta", "path",
        "Fasta format input sequences", NULL,
        NULL, &input_path_list);
    ArgumentSet_add_option(as, 'o', "output", "path",
        "Output path for .esd file", NULL,
        Argument_parse_string, &output_path);
    ArgumentSet_add_option(as, '\0', "dna", NULL,
        "Specify if input is DNA", "TRUE",
        Argument_parse_boolean, &is_dna);
    ArgumentSet_add_option(as, 's', "softmask", NULL,
        "Treat input sequences as softmasked", "FALSE",
        Argument_parse_boolean, &softmask_input);
    Argument_absorb_ArgumentSet(arg, as);
    Argument_process(arg, "fasta2esd",
        "generate an exonerate sequence database file\n"
        "Guy St.C. Slater. guy@ebi.ac.uk. 2006.\n", NULL);
    g_message("softmask [%d] dna [%d]", softmask_input, is_dna);
    dataset = Dataset_create(input_path_list, is_dna, softmask_input);
    Dataset_write(dataset, output_path);
    Dataset_destroy(dataset);
    return 0;
    }

