/*
 * farsight-plugin.h - Header for farsight plugin infrastructure
 *
 * Farsight Voice+Video library
 * Copyright (c) 2005 INdT.
 *   @author: Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 * Copyright (c) 2005,2006 Collabora Ltd.
 * Copyright (c) 2005,2006 Nokia Corp.
 *   @author: Rob Taylor <rob.taylor@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_PLUGIN_H__
#define __FARSIGHT_PLUGIN_H__

#include <glib.h>
#include <gmodule.h>
#include <gst/gst.h>

G_BEGIN_DECLS typedef struct _FarsightPlugin FarsightPlugin;
typedef struct _FarsightPluginInfo FarsightPluginInfo;

struct _FarsightPluginInfo
{
  guint major_version;          /* major version of core that plugin was compiled for */
  guint minor_version;          /* minor version of core that plugin was compiled for */

  gchar *description;           /* description of plugin */
  gchar *version;               /* version of the plugin */
  gchar *author;                /* author of the plugin */
  gchar *homepage;              /* homepage of the plugin */

  /* callbacks */
  /* This function is called when the first instance of the plugin is
   * created. It can be useful to allocate resources common for all
   * instances of the plugin. If all instances of the plugin are unloaded
   * and then the plugin is loaded again, this function will be called. */
  void (*load) (FarsightPlugin * plugin);
  /* This function is called when the last instance of the plugin is
   * unloaded. It can be useful to deallocate resources common for all
   * instances of the plugin. */
  void (*unload) (FarsightPlugin * plugin);
};

/**
 * FarsightPlugin:
 *
 * Class defining a Farsight plugin.
 */
struct _FarsightPlugin
{
  FarsightPluginInfo *info;
  GType type;
  GModule *handle;
  gchar *name;
  guint ref_count;
};

#define FARSIGHT_INIT_PLUGIN(initfunc, plugininfo) \
    G_MODULE_EXPORT gboolean farsight_init_plugin(FarsightPlugin *plugin) { \
        plugin->info = &(plugininfo); \
        return initfunc((plugin)); \
    }

FarsightPlugin *farsight_plugin_load (const gchar * name);
gboolean farsight_plugin_unload (FarsightPlugin * plugin);

G_CONST_RETURN gchar *farsight_plugin_get_name (FarsightPlugin * plugin);
G_CONST_RETURN gchar *farsight_plugin_get_description (FarsightPlugin *
    plugin);
G_CONST_RETURN gchar *farsight_plugin_get_version (FarsightPlugin * plugin);
G_CONST_RETURN gchar *farsight_plugin_get_author (FarsightPlugin * plugin);
G_CONST_RETURN gchar *farsight_plugin_get_homepage (FarsightPlugin * plugin);

G_END_DECLS
#endif
