/*
 * Farsight Voice+Video library
 *  Copyright 2006 Collabora Ltd, 
 *  Copyright 2006 Nokia Corporation
 *   @author: Philippe Khalaf <philippe.khalaf@collabora.co.uk>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __JINGLE_C_H__
#define __JINGLE_C_H__

#include <glib.h>

G_BEGIN_DECLS

typedef void* socketclient_t;

typedef void (*candidates_ready_cb_type) (gpointer creator, 
                                          const GList *candidates);
typedef void (*socket_state_change_cb_type) (gpointer creator, gint state);
typedef void (*network_error_cb_type) (gpointer creator);

typedef struct {
    gpointer callback;
    gpointer data;
} cb_info;

typedef struct {
    GMutex *mutex;
    GArray *candidates_ready_cb_array;
    GArray *socket_state_change_cb_array;
    GArray *network_error_cb_array;
} callback_list;

void connect_signal_candidates_ready (socketclient_t sockclient, 
                                      gpointer callback, 
                                      gpointer data);
void connect_signal_socket_state_change (socketclient_t sockclient, 
                                         gpointer callback, 
                                         gpointer data);
void connect_signal_network_error (socketclient_t sockclient,
                                   gpointer callback, 
                                   gpointer data);

socketclient_t socketclient_init (const gchar *stun_ip, 
                                  guint stun_port, 
                                  const gchar *turn_ip, 
                                  guint turn_port);
void socketclient_destroy (socketclient_t sockclient);

void socketclient_create_socket (socketclient_t sockclient,
                                 const gchar *name);
void socketclient_start_processing_candidates (socketclient_t sockclient);
void socketclient_add_remote_candidates (socketclient_t sockclient,
                                         const GList *remote_candidates);
gboolean socketclient_is_writable (socketclient_t sockclient);

void socketclient_send_packet (socketclient_t sockclient, const gchar *data,
                               guint len);

/*
void socketclient_set_candidate_ready_cb(socketclient_t sockclient,
        candidates_ready_cb_type, gpointer data);
void socketclient_set_state_cb(socketclient_t sockclient,
        socket_state_change_cb_type, gpointer data);
void socketclient_set_network_error_cb(socketclient_t sockclient,
        empty_cb_type, gpointer data);
*/

G_END_DECLS

#endif
