/* $Id: NormalizeAssocLists.hpp 4323 2009-01-27 13:48:12Z potyra $
 *
 * Normalize association lists.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __NORMALIZE_ASSOC_LISTS_HPP_INCLUDED
#define __NORMALIZE_ASSOC_LISTS_HPP_INCLUDED

#include "frontend/visitor/NullVisitor.hpp"
#include <list>
#include "frontend/ast/Location.hpp"
#include "frontend/misc/DeclarativeRegion.hpp"

namespace ast {

//! normalize association lists.
/** This class will reorder association lists into the corresponding
 *  order of the defining port-/parameter-list.
 *  FIXME: what to do with composites? and conversion functions?
 */
class NormalizeAssocLists : public NullVisitor {
public:
	//! c'tor: initialize members.
	NormalizeAssocLists(
		) : 	pickedUpSig(NULL), 
			pos(-1), 
			positional(true),
			region(NULL),
			arch(NULL),
			hiddenCounter(0) {}

private:
	/** Visit a CompInstStat node.
	 *  @param node CompInstStat node that get's visited.
	 */
	virtual void visit(CompInstStat& node);

	/** Visit a AssociationElement node.
	 *  @param node AssociationElement node that get's visited.
	 */
	virtual void visit(AssociationElement& node);

	/** visit a SimpleName
         *  @param node node that get's visited.
         */
	virtual void visit(SimpleName &node);

	/** visit a TemporaryName
         *  @param node node that get's visited.
         */
	virtual void visit(TemporaryName &node);

	/** visit a SelectedName
         *  @param node node that get's visited.
         */
	virtual void visit(SelectedName &node);

	/** visit a AttributeName
         *  @param node node that get's visited.
         */
	virtual void visit(AttributeName &node);

	/** Visit a Architecture node.
	 *
	 *  @param node Architecture node that get's visited.
	 */
	virtual void visit(Architecture& node);

	/** Visit a Library node.
	 *  @param node Library node that get's visited.
	 */
	virtual void visit(Library &node);

	/** Visit a LibraryList node.
	 *  @param node LibraryList node that get's visited.
	 */
	virtual void visit(LibraryList &node);

	/** find sig in ports and return the position. Also remove it from
	 *  also delete sig from ports and report an error
	 *  in case sig is not in ports.
	 *  @param sig signal to find/delete in current ports list
	 *  @param loc error location for error reporting.
	 *  @return position number or -1 on error.
	 */
	int findAndRemovePort(const SignalDeclaration *sig, Location errLoc);

	/** add associations for unassociated ports of a CompInstStat.
	 *  Reports errors.
	 *  @param node instantiation statement.
	 */
	void addMissingPortAssocs(CompInstStat &node);

	/** make a simple name referring to Signal sig which resides in 
	 *  declarative region lookupRegion.
	 *  @param sig Signal that should be referred to.
	 *  @param lookupRegion region in which sig is declared.
	 *  @param loc Location of the generated name.
	 *  @return SimpleName referring to sig or NULL on error.
	 */
	static SimpleName *
	makeNameOfSignal(
		const SignalDeclaration *sig, 
		const DeclarativeRegion *lookupRegion,
		Location loc);

	/** current port list. Consumed ports will be removed. */
	std::list<SignalDeclaration*> ports;
	
	/** when traversing to a named association, the picked up 
	 *  declaration lands here */
	const SignalDeclaration *pickedUpSig;

	/** current position of the first element of ports. */
	int pos;

	/** positional association used so far? */
	bool positional;

	/** region of the entity to lookup ports */
	const DeclarativeRegion *region;

	/** surrounding Architecture of a CompInstStat (or NULL) */
	const Architecture *arch;

	/** counter so that hidden signals have a unique name */
	int hiddenCounter;

	/** order predicate used for sorting port maps by position */
	static bool sortPosPred(AssociationElement *l, AssociationElement *r);
};

}; /* namespace ast */

#endif /* __NORMALIZE_ASSOC_LISTS_HPP_INCLUDED */
