/* $Id: RegisterFactory.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * RegisterFactory: create and keep track of virtual registers.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __REGISTER_FACTORY_HPP_INCLUDED
#define __REGISTER_FACTORY_HPP_INCLUDED

#include "intermediate/operands/Register.hpp"

namespace intermediate {

//! create virtual register (operands).
/** TODO keep better track of handed out vregs?
 */
class RegisterFactory {
public:
	//! create a virtual register
	/** @param type type of the virtual register operand
	 *  @return newly created virtual register.
	 */
	static Register*
	getRegister(enum OpType type);

	//! return the very return register
	/** @param type type of the return register.
	 *  @return the very return register
	 */
	static Register*
	getReturnRegister(enum OpType type);

	//! return the register containing the current simulation time.
	/** @return register containing the current simulation time.
	 */
	static Register*
	getSimTime(void);

private:
	//! counter of virtual registers.
	static int counter;
};

}; /* namespace intermediate */

#endif /* __REGISTER_FACTORY_HPP_INCLUDED */
