/* $Id: log.c 4321 2009-01-27 13:02:52Z potyra $
 *
 *  Utilitiy functions to log assertions messages.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "log.h"
#include <stdbool.h>
#include "glue-log.h"
#include "glue-main.h"
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <assert.h>

/* FIXME ripped from glue-main */
#define TIME_HZ		(1ULL << 32)

static void
log_begin(const char *lvl_msg)
{
	struct timeval tv;
	struct tm *tm;
	int ret;

	tv.tv_sec = time_virt() / TIME_HZ;
	tv.tv_usec = ((time_virt() % TIME_HZ) * 1000000) / TIME_HZ;

	/* Convert the time into a little more useful structure. */
	tm = localtime(&tv.tv_sec);
	if (tm == NULL) {
		perror("Couldn't break up system time");
		exit(1);
	}
	/* Generate the Oracle timestamp. */
	ret = fprintf(stdout, "%s: %.4d-%.2d-%.2d %.2d:%.2d:%.2d.%.6d ",
		lvl_msg,
		tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday,
		tm->tm_hour, tm->tm_min, tm->tm_sec, 
		(unsigned int)tv.tv_usec);

	if (ret < 0) {
		perror("Timestamp formatting error");
		exit(1);
	}
}
#undef TIME_HZ

void
log_vhdl(int level, char c)
{
	bool log_start = true;
	const char *severity;

	switch (level) {
	case -1:
		log_start = false;
		break;

	case 0:
		severity = "NOTE";
		break;

	case 1:
		severity = "WARNING";
		break;

	case 2:
		severity = "ERROR";
		break;

	case 3:
		severity = "FAILURE";
		break;

	default:
		faum_log(FAUM_LOG_ERROR, "fauhdli", __func__,
			"Illegal severity level %d\n", level);
		severity = "NOTE";
		break;
	}

	if (log_start) {
		log_begin(severity);
	}

	fprintf(stdout, "%c", c);
	if (c == '\n') {
		int ret = fflush(stdout);
		assert(ret == 0);
	}
}

