/* $Id: AttributeDeclaration.hpp 4323 2009-01-27 13:48:12Z potyra $
 *
 * AtributeDeclaration: AST Class representing an attribute declaration.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */
#ifndef __ATTRIBUTE_DECLARATION_HPP_INCLUDED
#define __ATTRIBUTE_DECLARATION_HPP_INCLUDED

#include "frontend/ast/SymbolDeclaration.hpp"
/* must use forward declaration of TypeDeclaration... otherwise circular */

namespace ast {

//! one generic VHDL attribute declaration.
class AttributeDeclaration : public SymbolDeclaration {
public:
	AttributeDeclaration(
		std::string *declName,
		const TypeDeclaration *t,
		Location loc
		) : 	SymbolDeclaration(declName, loc),
			type(t) {}
	
	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** type of the attribute */
	const TypeDeclaration *type;

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const;
};

}; /* namespace ast */

#endif /* __ATTRIBUTE_DECLARATION_HPP_INCLUDED */
