    library expect;
    use expect.types.all;
    use expect.procedures.all;

 5  entity node is
        generic( memsize  : integer := 256;
                 disksize : integer := 3000;
                 faults : integer := -1 );
        port( ext_eth0 : inout ethbus );
10  end node;

    architecture structural of node is
        signal int_mem : membus;
        signal int_isa : isabus;
15      signal int_gfx : gfxbus;
        signal int_ide0, int_ide1 : idebus;
        signal int_ps2kbd, int_ps2ms : ps2bus;

    begin
20      node : ctrl port map( keyboard => int_ps2kbd,
                              mouse    => int_ps2ms,
                              isa      => int_isa );

        cpu0 : cpu port map( mem => int_mem );
25
        mem0 : memory generic map( size => memsize )
                      port map( mem => int_mem );

        northsouth : mem2isa port map( mem => int_mem,
30                                     isa => int_isa );

        video : vga port map( mem => int_mem,
                              gfx => int_gfx );

35      mon : monitor port map( gfx => int_gfx );

        kbd   : keyboard port map( ps2 => int_ps2kbd );

        mouse : mouse port map( ps2 => int_ps2ms );
40
        eth0 : ne2000 port map( isa => int_isa );

        idectrl0 : idectrl port map( isa => int_isa,
                                     ide => int_ide0 );
45
        idectrl1 : idectrl port map( isa => int_isa,
                                     ide => int_ide1 );

        hda : idedisk generic map ( size => disksize,
50                                  unit => 0 )
                      port map( ide => int_ide0 );

        hdc : idecdrom generic map( unit => 0 )
                       port map( ide => int_ide1 );
55
    end structural;
