--
-- $Id: test_bench.vhdl,v 1.1 2009-02-17 13:30:10 potyra Exp $
--

library expect;
use expect.types.all;
use expect.procedures.all;
library ieee;
use ieee.std_logic_1164.ALL;

entity test_bench is
end test_bench;

architecture structural of test_bench is
	signal ext_eth: eth;
	signal pc1_power_button: boolean;
	signal pc1_cdrom: cstring;
	signal pc1_key: boolean_array(0 to 127);
	signal pc1_opt_screen: opt_rgb;
	signal pc1_screen_shot: integer;
	signal pc1_usb0 : usb_bus;
	signal pc1_usb1 : usb_bus;
	signal pc1_par : parallel;
	signal pc1_ser0 : serial;
	signal pc1_ser1 : serial;
	signal pc1_power_switch : boolean;
	signal pc1_reset_button : boolean;
	signal pc1_floppy : cstring;
	signal pc1_mouse_dx : integer;
	signal pc1_mouse_dy : integer;
	signal pc1_mouse_dz : integer;
	signal pc1_mouse_button1 : boolean;
	signal pc1_mouse_button2 : boolean;
	signal pc1_mouse_button3 : boolean;
	signal pc1_mouse_button4 : boolean;
	signal pc1_mouse_button5 : boolean;


	signal pc2_power_button: boolean;
	signal pc2_cdrom: cstring;
	signal pc2_key: boolean_array(0 to 127);
	signal pc2_opt_screen: opt_rgb;
	signal pc2_screen_shot: integer;
	signal pc2_usb0 : usb_bus;
	signal pc2_usb1 : usb_bus;
	signal pc2_par : parallel;
	signal pc2_ser0 : serial;
	signal pc2_ser1 : serial;
	signal pc2_power_switch : boolean;
	signal pc2_reset_button : boolean;
	signal pc2_floppy : cstring;
	signal pc2_mouse_dx : integer;
	signal pc2_mouse_dy : integer;
	signal pc2_mouse_dz : integer;
	signal pc2_mouse_button1 : boolean;
	signal pc2_mouse_button2 : boolean;
	signal pc2_mouse_button3 : boolean;
	signal pc2_mouse_button4 : boolean;
	signal pc2_mouse_button5 : boolean;


--	signal nr_console : serial;
	signal fault: integer;
begin
	pc1: pc_standard
		generic map (
			memsize => 128,
			disksize => 32
		)
		port map (
			ext_eth0 => ext_eth,
			power_button => pc1_power_button,
			cdrom => pc1_cdrom,
			key => pc1_key,
			opt_screen => pc1_opt_screen,
			screen_shot => pc1_screen_shot,
			ext_usb0 => pc1_usb0,
			ext_usb1 => pc1_usb1,
			ext_par => pc1_par,
			ext_ser0 => pc1_ser0,
			ext_ser1 => pc1_ser1,
			power_switch => pc1_power_switch,
			reset_button => pc1_reset_button,
			floppy => pc1_floppy,
			mouse_dx => pc1_mouse_dx,
			mouse_dy => pc1_mouse_dy,
			mouse_dz => pc1_mouse_dz,
			mouse_button1 => pc1_mouse_button1,
			mouse_button2 => pc1_mouse_button2,
			mouse_button3 => pc1_mouse_button3,
			mouse_button4 => pc1_mouse_button4,
			mouse_button5 => pc1_mouse_button5
		);
	pc2: pc_standard
		generic map (
			memsize => 128,
			disksize => 32
		)
		port map (
			ext_eth0 => ext_eth,
			power_button => pc2_power_button,
			cdrom => pc2_cdrom,
			key => pc2_key,
			opt_screen => pc2_opt_screen,
			screen_shot => pc2_screen_shot,
			ext_usb0 => pc2_usb0,
			ext_usb1 => pc2_usb1,
			ext_par => pc2_par,
			ext_ser0 => pc2_ser0,
			ext_ser1 => pc2_ser1,
			power_switch => pc2_power_switch,
			reset_button => pc2_reset_button,
			floppy => pc2_floppy,
			mouse_dx => pc2_mouse_dx,
			mouse_dy => pc2_mouse_dy,
			mouse_dz => pc2_mouse_dz,
			mouse_button1 => pc2_mouse_button1,
			mouse_button2 => pc2_mouse_button2,
			mouse_button3 => pc2_mouse_button3,
			mouse_button4 => pc2_mouse_button4,
			mouse_button5 => pc2_mouse_button5
		);
--	bridge: network_router
--		port map (
--			eth => ext_eth,
--			console => nr_console
--		);
	
	dhcp_server : dhcp_server
		port map(
			eth => ext_eth
		);

	user: user
		port map (
			pc1_power_button => pc1_power_button,
			pc1_cdrom => pc1_cdrom,
			pc1_key => pc1_key,
			pc1_opt_screen => pc1_opt_screen,
			pc1_screen_shot => pc1_screen_shot,
			pc2_power_button => pc2_power_button,
			pc2_cdrom => pc2_cdrom,
			pc2_key => pc2_key,
			pc2_opt_screen => pc2_opt_screen,
			pc2_screen_shot => pc2_screen_shot
		);
end structural;
